/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import me.hsgamer.hscore.bukkit.gui.BukkitGUIDisplay;
import me.hsgamer.hscore.bukkit.gui.BukkitGUIUtils;
import me.hsgamer.hscore.minecraft.gui.GUIHolder;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitGUIHolder
extends GUIHolder<BukkitGUIDisplay> {
    private final Plugin plugin;
    private InventoryType inventoryType = InventoryType.CHEST;
    private Function<UUID, String> titleFunction = uuid -> this.inventoryType.getDefaultTitle();
    private ToIntFunction<UUID> sizeFunction = uuid -> InventoryType.CHEST.getDefaultSize();
    private BiFunction<BukkitGUIDisplay, UUID, Inventory> inventoryFunction = (display, uuid) -> {
        BukkitGUIHolder holder = (BukkitGUIHolder)display.getHolder();
        InventoryType type = holder.getInventoryType();
        int size = holder.getSize((UUID)uuid);
        String title = holder.getTitle((UUID)uuid);
        return type == InventoryType.CHEST && size > 0 ? Bukkit.createInventory((InventoryHolder)display, (int)BukkitGUIUtils.normalizeToChestSize(size), (String)title) : Bukkit.createInventory((InventoryHolder)display, (InventoryType)type, (String)title);
    };

    public BukkitGUIHolder(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public Function<UUID, String> getTitleFunction() {
        return this.titleFunction;
    }

    public void setTitleFunction(Function<UUID, String> titleFunction) {
        this.titleFunction = titleFunction;
    }

    public String getTitle(UUID uuid) {
        return this.titleFunction.apply(uuid);
    }

    public void setTitle(String title) {
        this.setTitleFunction(uuid -> title);
    }

    public ToIntFunction<UUID> getSizeFunction() {
        return this.sizeFunction;
    }

    public void setSizeFunction(ToIntFunction<UUID> sizeFunction) {
        this.sizeFunction = sizeFunction;
    }

    public int getSize(UUID uuid) {
        return this.sizeFunction.applyAsInt(uuid);
    }

    public void setSize(int size) {
        this.setSizeFunction(uuid -> size);
    }

    public BiFunction<BukkitGUIDisplay, UUID, Inventory> getInventoryFunction() {
        return this.inventoryFunction;
    }

    public void setInventoryFunction(BiFunction<BukkitGUIDisplay, UUID, Inventory> inventoryFunction) {
        this.inventoryFunction = inventoryFunction;
    }

    @NotNull
    protected BukkitGUIDisplay newDisplay(UUID uuid) {
        return new BukkitGUIDisplay(uuid, this);
    }

    protected void onRemoveDisplay(@NotNull BukkitGUIDisplay display) {
        display.getInventory().getViewers().stream().filter(viewer -> viewer.getUniqueId() != display.getUniqueId()).forEach(HumanEntity::closeInventory);
    }

    public void init() {
        super.init();
        this.addEventConsumer(InventoryDragEvent.class, this::onDrag);
    }

    protected void closeAll(List<BukkitGUIDisplay> displays) {
        displays.forEach(display -> new ArrayList<HumanEntity>(display.getInventory().getViewers()).forEach(HumanEntity::closeInventory));
    }

    protected void onDrag(InventoryDragEvent event) {
    }
}

