/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.hscore.bukkit.gui.BukkitGUIDisplay;
import me.hsgamer.hscore.bukkit.gui.BukkitGUIUtils;
import me.hsgamer.hscore.bukkit.gui.event.BukkitDragEvent;
import me.hsgamer.hscore.minecraft.gui.GUIHolder;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitGUIHolder
extends GUIHolder<BukkitGUIDisplay> {
    private final Plugin plugin;
    private InventoryType inventoryType = InventoryType.CHEST;
    private int size = InventoryType.CHEST.getDefaultSize();
    private Function<BukkitGUIDisplay, Inventory> inventoryFunction = BukkitGUIUtils.getDefaultInventoryFunction();

    public BukkitGUIHolder(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Function<BukkitGUIDisplay, Inventory> getInventoryFunction() {
        return this.inventoryFunction;
    }

    public void setInventoryFunction(Function<BukkitGUIDisplay, Inventory> inventoryFunction) {
        this.inventoryFunction = inventoryFunction;
    }

    public void setTitleFunction(Function<UUID, String> titleFunction) {
        this.setInventoryFunction(BukkitGUIUtils.getInventoryFunctionFromTitle(titleFunction));
    }

    public void setTitle(String title) {
        this.setTitleFunction(uuid -> title);
    }

    @NotNull
    protected BukkitGUIDisplay newDisplay(UUID uuid) {
        return new BukkitGUIDisplay(uuid, this);
    }

    public void init() {
        super.init();
        this.addEventConsumer(BukkitDragEvent.class, this::onDrag);
    }

    protected void closeAll(List<BukkitGUIDisplay> displays) {
        displays.forEach(display -> new ArrayList<HumanEntity>(display.getInventory().getViewers()).forEach(HumanEntity::closeInventory));
    }

    protected void onDrag(BukkitDragEvent event) {
    }
}

