/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.key;

import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PluginKeyPair<Z> {
    private final NamespacedKey key;
    private final PersistentDataType<?, Z> dataType;
    private final Z defaultValue;

    public PluginKeyPair(NamespacedKey key, PersistentDataType<?, Z> dataType, Z defaultValue) {
        this.key = key;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public PersistentDataType<?, Z> getDataType() {
        return this.dataType;
    }

    public Z getDefaultValue() {
        return this.defaultValue;
    }

    public Z get(PersistentDataContainer container) {
        return (Z)container.getOrDefault(this.key, this.dataType, this.defaultValue);
    }

    public void set(PersistentDataContainer container, Z value) {
        if (value == null) {
            this.remove(container);
        } else {
            container.set(this.key, this.dataType, value);
        }
    }

    public Z get(PersistentDataHolder holder) {
        return this.get(holder.getPersistentDataContainer());
    }

    public void set(PersistentDataHolder holder, Z value) {
        this.set(holder.getPersistentDataContainer(), value);
    }

    public boolean contains(PersistentDataContainer container) {
        return container.has(this.key, this.dataType);
    }

    public boolean contains(PersistentDataHolder holder) {
        return this.contains(holder.getPersistentDataContainer());
    }

    public void copy(PersistentDataContainer fromContainer, PersistentDataContainer toContainer) {
        Z value = this.get(fromContainer);
        this.set(toContainer, value);
    }

    public void copy(PersistentDataHolder fromHolder, PersistentDataHolder toHolder) {
        this.copy(fromHolder.getPersistentDataContainer(), toHolder.getPersistentDataContainer());
    }

    public void remove(PersistentDataContainer container) {
        container.remove(this.key);
    }

    public void remove(PersistentDataHolder holder) {
        this.remove(holder.getPersistentDataContainer());
    }
}

