package me.hsgamer.hscore.bukkit.scheduler;

/**
 * The task generated by {@link me.hsgamer.hscore.bukkit.scheduler.Scheduler}
 */
public interface Task {
  /**
   * Create a completed task
   *
   * @param async     whether the task is async
   * @param repeating whether the task is repeating
   *
   * @return the completed task
   */
  static Task completed(boolean async, boolean repeating) {
    return new Task() {
      @Override
      public boolean isCancelled() {
        return true;
      }

      @Override
      public void cancel() {
        // Do nothing
      }

      @Override
      public boolean isAsync() {
        return async;
      }

      @Override
      public boolean isRepeating() {
        return repeating;
      }
    };
  }

  /**
   * Check if the task is cancelled
   *
   * @return true if the task is cancelled
   */
  boolean isCancelled();

  /**
   * Cancel the task
   */
  void cancel();

  /**
   * Check if the task is async
   *
   * @return true if the task is async
   */
  boolean isAsync();

  /**
   * Check if the task is repeating
   *
   * @return true if the task is repeating
   */
  boolean isRepeating();
}
