/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import me.hsgamer.hscore.bukkit.folia.FoliaChecker;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.bukkit.BukkitScheduler;
import me.hsgamer.hscore.bukkit.scheduler.folia.FoliaScheduler;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public interface Scheduler {
    public static final Scheduler CURRENT = ((Supplier<Scheduler>)() -> {
        if (FoliaChecker.isFolia()) {
            return new FoliaScheduler();
        }
        return new BukkitScheduler();
    }).get();

    public void cancelAllTasks(Plugin var1);

    public Task runTask(Plugin var1, Runnable var2, boolean var3);

    public Task runTaskLater(Plugin var1, Runnable var2, long var3, boolean var5);

    public Task runTaskTimer(Plugin var1, BooleanSupplier var2, long var3, long var5, boolean var7);

    default public Task runTaskTimer(Plugin plugin, Runnable runnable, long delay, long period, boolean async) {
        return this.runTaskTimer(plugin, () -> {
            runnable.run();
            return true;
        }, delay, period, async);
    }

    public Task runEntityTask(Plugin var1, Entity var2, Runnable var3, Runnable var4, boolean var5);

    public Task runEntityTaskLater(Plugin var1, Entity var2, Runnable var3, Runnable var4, long var5, boolean var7);

    public Task runEntityTaskTimer(Plugin var1, Entity var2, BooleanSupplier var3, Runnable var4, long var5, long var7, boolean var9);

    default public Task runEntityTaskTimer(Plugin plugin, Entity entity, Runnable runnable, Runnable retired, long delay, long period, boolean async) {
        return this.runEntityTaskTimer(plugin, entity, () -> {
            runnable.run();
            return true;
        }, retired, delay, period, async);
    }

    default public Task runEntityTask(Plugin plugin, Entity entity, Runnable runnable, boolean async) {
        return this.runEntityTask(plugin, entity, runnable, () -> {}, async);
    }

    default public Task runEntityTaskLater(Plugin plugin, Entity entity, Runnable runnable, long delay, boolean async) {
        return this.runEntityTaskLater(plugin, entity, runnable, () -> {}, delay, async);
    }

    default public Task runEntityTaskTimer(Plugin plugin, Entity entity, BooleanSupplier runnable, long delay, long period, boolean async) {
        return this.runEntityTaskTimer(plugin, entity, runnable, () -> {}, delay, period, async);
    }

    default public Task runEntityTaskTimer(Plugin plugin, Entity entity, Runnable runnable, long delay, long period, boolean async) {
        return this.runEntityTaskTimer(plugin, entity, runnable, () -> {}, delay, period, async);
    }

    default public Task runEntityTaskWithFinalizer(Plugin plugin, Entity entity, Runnable runnable, Runnable finalizer, boolean async) {
        return this.runEntityTask(plugin, entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer, async);
    }

    default public Task runEntityTaskLaterWithFinalizer(Plugin plugin, Entity entity, Runnable runnable, Runnable finalizer, long delay, boolean async) {
        return this.runEntityTaskLater(plugin, entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer, delay, async);
    }

    public Task runLocationTask(Plugin var1, Location var2, Runnable var3);

    public Task runLocationTaskLater(Plugin var1, Location var2, Runnable var3, long var4);

    public Task runLocationTaskTimer(Plugin var1, Location var2, BooleanSupplier var3, long var4, long var6);

    default public Task runLocationTaskTimer(Plugin plugin, Location location, Runnable runnable, long delay, long period) {
        return this.runLocationTaskTimer(plugin, location, () -> {
            runnable.run();
            return true;
        }, delay, period);
    }
}

