/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.hscore.bukkit.scheduler.Scheduler;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements Scheduler {
    private final Map<Plugin, Set<ScheduledTask>> pluginTaskMap = new ConcurrentHashMap<Plugin, Set<ScheduledTask>>();

    private void addTask(Plugin plugin, ScheduledTask scheduledTask) {
        this.pluginTaskMap.computeIfAbsent(plugin, p -> ConcurrentHashMap.newKeySet()).add(scheduledTask);
    }

    private long normalizeTick(long tick) {
        return Math.max(1L, tick);
    }

    private long toMilliSecond(long tick) {
        return this.normalizeTick(tick) * 50L;
    }

    private Consumer<ScheduledTask> wrapRunnable(BooleanSupplier runnable) {
        return scheduledTask -> {
            if (!runnable.getAsBoolean()) {
                scheduledTask.cancel();
            }
        };
    }

    private Task wrapTask(final ScheduledTask scheduledTask, final boolean async) {
        return new Task(){

            @Override
            public boolean isCancelled() {
                return scheduledTask.isCancelled();
            }

            @Override
            public void cancel() {
                scheduledTask.cancel();
            }

            @Override
            public boolean isAsync() {
                return async;
            }

            @Override
            public boolean isRepeating() {
                return scheduledTask.isRepeatingTask();
            }
        };
    }

    private boolean isEntityValid(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            return ((Player)entity).isOnline();
        }
        return entity.isValid();
    }

    private Consumer<ScheduledTask> wrapRunnable(Entity entity, BooleanSupplier runnable, Runnable retired) {
        return scheduledTask -> {
            if (this.isEntityValid(entity)) {
                if (!runnable.getAsBoolean()) {
                    scheduledTask.cancel();
                }
            } else {
                retired.run();
                scheduledTask.cancel();
            }
        };
    }

    private Consumer<ScheduledTask> wrapRunnable(Entity entity, Runnable runnable, Runnable retired) {
        return this.wrapRunnable(entity, () -> {
            runnable.run();
            return true;
        }, retired);
    }

    @Override
    public void cancelAllTasks(Plugin plugin) {
        Set<ScheduledTask> scheduledTasks = this.pluginTaskMap.remove(plugin);
        if (scheduledTasks != null) {
            scheduledTasks.forEach(scheduledTask -> {
                if (!scheduledTask.isCancelled()) {
                    scheduledTask.cancel();
                }
            });
            scheduledTasks.clear();
        }
        Bukkit.getAsyncScheduler().cancelTasks(plugin);
        Bukkit.getGlobalRegionScheduler().cancelTasks(plugin);
    }

    @Override
    public Task runTask(Plugin plugin, Runnable runnable, boolean async) {
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runNow(plugin, s -> runnable.run()) : Bukkit.getGlobalRegionScheduler().run(plugin, s -> runnable.run());
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runTaskLater(Plugin plugin, Runnable runnable, long delay, boolean async) {
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runDelayed(plugin, s -> runnable.run(), this.toMilliSecond(delay), TimeUnit.MILLISECONDS) : Bukkit.getGlobalRegionScheduler().runDelayed(plugin, s -> runnable.run(), this.normalizeTick(delay));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runTaskTimer(Plugin plugin, BooleanSupplier runnable, long delay, long period, boolean async) {
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runAtFixedRate(plugin, this.wrapRunnable(runnable), this.toMilliSecond(delay), this.toMilliSecond(period), TimeUnit.MILLISECONDS) : Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, this.wrapRunnable(runnable), this.normalizeTick(delay), this.normalizeTick(period));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runEntityTask(Plugin plugin, Entity entity, Runnable runnable, Runnable retired, boolean async) {
        if (!this.isEntityValid(entity)) {
            return this.runTask(plugin, retired, async);
        }
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runNow(plugin, this.wrapRunnable(entity, runnable, retired)) : entity.getScheduler().run(plugin, s -> runnable.run(), retired);
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runEntityTaskLater(Plugin plugin, Entity entity, Runnable runnable, Runnable retired, long delay, boolean async) {
        if (!this.isEntityValid(entity)) {
            return this.runTaskLater(plugin, retired, delay, async);
        }
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runDelayed(plugin, this.wrapRunnable(entity, runnable, retired), this.toMilliSecond(delay), TimeUnit.MILLISECONDS) : entity.getScheduler().runDelayed(plugin, s -> runnable.run(), retired, this.normalizeTick(delay));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runEntityTaskTimer(Plugin plugin, Entity entity, BooleanSupplier runnable, Runnable retired, long delay, long period, boolean async) {
        if (!this.isEntityValid(entity)) {
            return this.runTaskLater(plugin, retired, delay, async);
        }
        ScheduledTask scheduledTask = async ? Bukkit.getAsyncScheduler().runAtFixedRate(plugin, this.wrapRunnable(entity, runnable, retired), this.toMilliSecond(delay), this.toMilliSecond(period), TimeUnit.MILLISECONDS) : entity.getScheduler().runAtFixedRate(plugin, this.wrapRunnable(runnable), retired, this.normalizeTick(delay), this.normalizeTick(period));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, async);
    }

    @Override
    public Task runLocationTask(Plugin plugin, Location location, Runnable runnable) {
        ScheduledTask scheduledTask = Bukkit.getRegionScheduler().run(plugin, location, s -> runnable.run());
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, false);
    }

    @Override
    public Task runLocationTaskLater(Plugin plugin, Location location, Runnable runnable, long delay) {
        ScheduledTask scheduledTask = Bukkit.getRegionScheduler().runDelayed(plugin, location, s -> runnable.run(), this.normalizeTick(delay));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, false);
    }

    @Override
    public Task runLocationTaskTimer(Plugin plugin, Location location, BooleanSupplier runnable, long delay, long period) {
        ScheduledTask scheduledTask = Bukkit.getRegionScheduler().runAtFixedRate(plugin, location, this.wrapRunnable(runnable), this.normalizeTick(delay), this.normalizeTick(period));
        this.addTask(plugin, scheduledTask);
        return this.wrapTask(scheduledTask, false);
    }
}

