/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.hscore.bukkit.scheduler.Runner;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.TaskTime;
import me.hsgamer.hscore.bukkit.scheduler.TimerTaskTime;
import me.hsgamer.hscore.bukkit.scheduler.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

class FoliaAsyncRunner
implements Runner {
    private final FoliaScheduler scheduler;

    FoliaAsyncRunner(FoliaScheduler scheduler) {
        this.scheduler = scheduler;
    }

    private void addTask(ScheduledTask task) {
        this.scheduler.addTask(task);
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(final Entity entity, final BooleanSupplier runnable, final Runnable retired) {
        return new Consumer<ScheduledTask>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(ScheduledTask scheduledTask) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (FoliaScheduler.isEntityValid(entity)) {
                        if (!runnable.getAsBoolean()) {
                            scheduledTask.cancel();
                        }
                    } else {
                        retired.run();
                        scheduledTask.cancel();
                    }
                }
            }
        };
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(Entity entity, Runnable runnable, Runnable retired) {
        return this.wrapEntityRunnable(entity, () -> {
            runnable.run();
            return true;
        }, retired);
    }

    @Override
    public Task runTask(Runnable runnable) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runTaskLater(Runnable runnable, TaskTime delay) {
        long time = delay.getTime();
        ScheduledTask task = time > 0L ? Bukkit.getAsyncScheduler().runDelayed(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), time, delay.getUnit()) : Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runTaskTimer(BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        long delay = timerTaskTime.getDelay();
        long period = timerTaskTime.getNormalizedPeriod();
        Consumer<ScheduledTask> wrappedRunnable = FoliaScheduler.wrapRunnable(runnable);
        if (delay <= 0L) {
            this.addTask(Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), wrappedRunnable));
        }
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), wrappedRunnable, delay <= 0L ? period : delay, period, timerTaskTime.getUnit());
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTask(Entity entity, Runnable runnable, Runnable retired) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTaskLater(Entity entity, Runnable runnable, Runnable retired, TaskTime delay) {
        long time = delay.getTime();
        ScheduledTask task = time > 0L ? Bukkit.getAsyncScheduler().runDelayed(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired), time, delay.getUnit()) : Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, Runnable retired, TimerTaskTime timerTaskTime) {
        long delay = timerTaskTime.getDelay();
        long period = timerTaskTime.getNormalizedPeriod();
        Consumer<ScheduledTask> wrappedRunnable = this.wrapEntityRunnable(entity, runnable, retired);
        if (delay <= 0L) {
            this.addTask(Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), wrappedRunnable));
        }
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), wrappedRunnable, delay <= 0L ? period : delay, period, timerTaskTime.getUnit());
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runLocationTask(Location location, Runnable runnable) {
        return this.runTask(runnable);
    }

    @Override
    public Task runLocationTaskLater(Location location, Runnable runnable, TaskTime delay) {
        return this.runTaskLater(runnable, delay);
    }

    @Override
    public Task runLocationTaskTimer(Location location, BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        return this.runTaskTimer(runnable, timerTaskTime);
    }
}

