/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.hscore.bukkit.scheduler.Runner;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.TaskTime;
import me.hsgamer.hscore.bukkit.scheduler.TimerTaskTime;
import me.hsgamer.hscore.bukkit.scheduler.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

class FoliaSyncRunner
implements Runner {
    private final FoliaScheduler scheduler;

    FoliaSyncRunner(FoliaScheduler scheduler) {
        this.scheduler = scheduler;
    }

    private void addTask(ScheduledTask task) {
        this.scheduler.addTask(task);
    }

    @Override
    public Task runTask(Runnable runnable) {
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().run(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runTaskLater(Runnable runnable, TaskTime delay) {
        long time = delay.getTicks();
        ScheduledTask task = time > 0L ? Bukkit.getGlobalRegionScheduler().runDelayed(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), time) : Bukkit.getGlobalRegionScheduler().run(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runTaskTimer(BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        long delay = timerTaskTime.getDelayTicks();
        long period = timerTaskTime.getNormalizedPeriodTicks();
        Consumer<ScheduledTask> wrappedRunnable = FoliaScheduler.wrapRunnable(runnable);
        if (delay <= 0L) {
            this.addTask(Bukkit.getGlobalRegionScheduler().run(this.scheduler.getPlugin(), wrappedRunnable));
        }
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.scheduler.getPlugin(), wrappedRunnable, delay <= 0L ? period : delay, period);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runEntityTask(Entity entity, Runnable runnable, Runnable retired) {
        if (!FoliaScheduler.isEntityValid(entity)) {
            return this.runTask(retired);
        }
        ScheduledTask task = entity.getScheduler().run(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), retired);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runEntityTaskLater(Entity entity, Runnable runnable, Runnable retired, TaskTime delay) {
        if (!FoliaScheduler.isEntityValid(entity)) {
            return this.runTaskLater(retired, delay);
        }
        long time = delay.getTicks();
        ScheduledTask task = time > 0L ? entity.getScheduler().runDelayed(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), retired, time) : entity.getScheduler().run(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), retired);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, Runnable retired, TimerTaskTime timerTaskTime) {
        if (!FoliaScheduler.isEntityValid(entity)) {
            return this.runTaskLater(retired, TaskTime.of(timerTaskTime.getDelayTicks()));
        }
        long delay = timerTaskTime.getDelayTicks();
        long period = timerTaskTime.getNormalizedPeriodTicks();
        Consumer<ScheduledTask> wrappedRunnable = FoliaScheduler.wrapRunnable(runnable);
        if (delay <= 0L) {
            this.addTask(entity.getScheduler().run(this.scheduler.getPlugin(), wrappedRunnable, retired));
        }
        ScheduledTask task = entity.getScheduler().runAtFixedRate(this.scheduler.getPlugin(), wrappedRunnable, retired, delay <= 0L ? period : delay, period);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runLocationTask(Location location, Runnable runnable) {
        ScheduledTask task = Bukkit.getRegionScheduler().run(this.scheduler.getPlugin(), location, FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runLocationTaskLater(Location location, Runnable runnable, TaskTime delay) {
        long time = delay.getTicks();
        ScheduledTask task = time > 0L ? Bukkit.getRegionScheduler().runDelayed(this.scheduler.getPlugin(), location, FoliaScheduler.wrapRunnable(runnable), time) : Bukkit.getRegionScheduler().run(this.scheduler.getPlugin(), location, FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }

    @Override
    public Task runLocationTaskTimer(Location location, BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        long delay = timerTaskTime.getDelayTicks();
        long period = timerTaskTime.getNormalizedPeriodTicks();
        Consumer<ScheduledTask> wrappedRunnable = FoliaScheduler.wrapRunnable(runnable);
        if (delay <= 0L) {
            this.addTask(Bukkit.getRegionScheduler().run(this.scheduler.getPlugin(), location, wrappedRunnable));
        }
        ScheduledTask task = Bukkit.getRegionScheduler().runAtFixedRate(this.scheduler.getPlugin(), location, wrappedRunnable, delay <= 0L ? period : delay, period);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, false);
    }
}

