/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler;

import java.util.function.BooleanSupplier;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.TaskTime;
import me.hsgamer.hscore.bukkit.scheduler.TimerTaskTime;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public interface Runner {
    public Task runTask(Runnable var1);

    public Task runTaskLater(Runnable var1, TaskTime var2);

    public Task runTaskTimer(BooleanSupplier var1, TimerTaskTime var2);

    default public Task runTaskTimer(Runnable runnable, TimerTaskTime timerTaskTime) {
        return this.runTaskTimer(() -> {
            runnable.run();
            return true;
        }, timerTaskTime);
    }

    public Task runEntityTask(Entity var1, Runnable var2, Runnable var3);

    public Task runEntityTaskLater(Entity var1, Runnable var2, Runnable var3, TaskTime var4);

    public Task runEntityTaskTimer(Entity var1, BooleanSupplier var2, Runnable var3, TimerTaskTime var4);

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, Runnable retired, TimerTaskTime timerTaskTime) {
        return this.runEntityTaskTimer(entity, () -> {
            runnable.run();
            return true;
        }, retired, timerTaskTime);
    }

    default public Task runEntityTaskLater(Entity entity, Runnable runnable, TaskTime delay) {
        return this.runEntityTaskLater(entity, runnable, () -> {}, delay);
    }

    default public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, timerTaskTime);
    }

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, TimerTaskTime timerTaskTime) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, timerTaskTime);
    }

    default public Task runEntityTaskLaterWithFinalizer(Entity entity, Runnable runnable, Runnable finalizer, TaskTime delay) {
        return this.runEntityTaskLater(entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer, delay);
    }

    public Task runLocationTask(Location var1, Runnable var2);

    public Task runLocationTaskLater(Location var1, Runnable var2, TaskTime var3);

    public Task runLocationTaskTimer(Location var1, BooleanSupplier var2, TimerTaskTime var3);

    default public Task runLocationTaskTimer(Location location, Runnable runnable, TimerTaskTime timerTaskTime) {
        return this.runLocationTaskTimer(location, () -> {
            runnable.run();
            return true;
        }, timerTaskTime);
    }

    default public Task runTaskLater(Runnable runnable, long delay) {
        return this.runTaskLater(runnable, TaskTime.of(delay));
    }

    default public Task runTaskTimer(BooleanSupplier runnable, long delay, long period) {
        return this.runTaskTimer(runnable, TimerTaskTime.of(delay, period));
    }

    default public Task runTaskTimer(Runnable runnable, long delay, long period) {
        return this.runTaskTimer(() -> {
            runnable.run();
            return true;
        }, delay, period);
    }

    default public Task runEntityTaskLater(Entity entity, Runnable runnable, Runnable retired, long delay) {
        return this.runEntityTaskLater(entity, runnable, retired, TaskTime.of(delay));
    }

    default public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, Runnable retired, long delay, long period) {
        return this.runEntityTaskTimer(entity, runnable, retired, TimerTaskTime.of(delay, period));
    }

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, Runnable retired, long delay, long period) {
        return this.runEntityTaskTimer(entity, () -> {
            runnable.run();
            return true;
        }, retired, delay, period);
    }

    default public Task runEntityTask(Entity entity, Runnable runnable) {
        return this.runEntityTask(entity, runnable, () -> {});
    }

    default public Task runEntityTaskLater(Entity entity, Runnable runnable, long delay) {
        return this.runEntityTaskLater(entity, runnable, () -> {}, delay);
    }

    default public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, long delay, long period) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, delay, period);
    }

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, long delay, long period) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, delay, period);
    }

    default public Task runEntityTaskWithFinalizer(Entity entity, Runnable runnable, Runnable finalizer) {
        return this.runEntityTask(entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer);
    }

    default public Task runEntityTaskLaterWithFinalizer(Entity entity, Runnable runnable, Runnable finalizer, long delay) {
        return this.runEntityTaskLater(entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer, delay);
    }

    default public Task runLocationTaskLater(Location location, Runnable runnable, long delay) {
        return this.runLocationTaskLater(location, runnable, TaskTime.of(delay));
    }

    default public Task runLocationTaskTimer(Location location, BooleanSupplier runnable, long delay, long period) {
        return this.runLocationTaskTimer(location, runnable, TimerTaskTime.of(delay, period));
    }

    default public Task runLocationTaskTimer(Location location, Runnable runnable, long delay, long period) {
        return this.runLocationTaskTimer(location, () -> {
            runnable.run();
            return true;
        }, delay, period);
    }
}

