/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.bukkit;

import java.util.function.BooleanSupplier;
import me.hsgamer.hscore.bukkit.scheduler.Runner;
import me.hsgamer.hscore.bukkit.scheduler.Scheduler;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.bukkit.BukkitAsyncRunner;
import me.hsgamer.hscore.bukkit.scheduler.bukkit.BukkitSyncRunner;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BukkitScheduler
implements Scheduler {
    private final BukkitSyncRunner syncRunner;
    private final BukkitAsyncRunner asyncRunner;
    private final Plugin plugin;

    public BukkitScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.syncRunner = new BukkitSyncRunner(this);
        this.asyncRunner = new BukkitAsyncRunner(this);
    }

    static BukkitRunnable wrapRunnable(final Runnable runnable) {
        return new BukkitRunnable(){

            public void run() {
                runnable.run();
            }
        };
    }

    static BukkitRunnable wrapRunnable(final BooleanSupplier runnable) {
        return new BukkitRunnable(){

            public void run() {
                if (!runnable.getAsBoolean()) {
                    this.cancel();
                }
            }
        };
    }

    static boolean isEntityValid(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            return ((Player)entity).isOnline();
        }
        return entity.isValid();
    }

    static BukkitRunnable wrapRunnable(final Entity entity, final BooleanSupplier runnable, final Runnable retired) {
        return new BukkitRunnable(){

            public void run() {
                if (BukkitScheduler.isEntityValid(entity)) {
                    if (!runnable.getAsBoolean()) {
                        this.cancel();
                    }
                } else {
                    retired.run();
                    this.cancel();
                }
            }
        };
    }

    static BukkitRunnable wrapRunnable(Entity entity, Runnable runnable, Runnable retired) {
        return BukkitScheduler.wrapRunnable(entity, () -> {
            runnable.run();
            return true;
        }, retired);
    }

    static Task wrapTask(final BukkitTask bukkitTask, final boolean repeating) {
        return new Task(){

            @Override
            public boolean isCancelled() {
                try {
                    return bukkitTask.isCancelled();
                }
                catch (Throwable throwable) {
                    int taskId = bukkitTask.getTaskId();
                    return !Bukkit.getScheduler().isQueued(taskId) && !Bukkit.getScheduler().isCurrentlyRunning(taskId);
                }
            }

            @Override
            public void cancel() {
                bukkitTask.cancel();
            }

            @Override
            public boolean isAsync() {
                return !bukkitTask.isSync();
            }

            @Override
            public boolean isRepeating() {
                return repeating;
            }

            @Override
            public Plugin getPlugin() {
                return bukkitTask.getOwner();
            }
        };
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void cancelAllTasks() {
        Bukkit.getScheduler().cancelTasks(this.plugin);
    }

    @Override
    public Runner async() {
        return this.asyncRunner;
    }

    @Override
    public Runner sync() {
        return this.syncRunner;
    }
}

