/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler;

import java.util.concurrent.TimeUnit;

public class TaskTime {
    private final long time;
    private final TimeUnit unit;
    private final long ticks;

    private TaskTime(long time, TimeUnit unit) {
        this.time = Math.max(time, 0L);
        this.unit = unit;
        this.ticks = unit.toMillis(this.time) / 50L;
    }

    public static TaskTime of(long time, TimeUnit unit) {
        return new TaskTime(time, unit);
    }

    public static TaskTime of(long ticks) {
        return new TaskTime(ticks * 50L, TimeUnit.MILLISECONDS);
    }

    public long getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getTicks() {
        return this.ticks;
    }

    public long getNormalizedTicks() {
        return Math.max(this.ticks, 1L);
    }
}

