/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler;

import java.util.concurrent.TimeUnit;

public class TimerTaskTime {
    private final long delay;
    private final long period;
    private final TimeUnit unit;
    private final long delayTicks;
    private final long periodTicks;
    private final boolean fromTicks;

    private TimerTaskTime(long delay, long period, TimeUnit unit, boolean fromTicks) {
        this.delay = Math.max(0L, delay);
        this.period = Math.max(0L, period);
        this.unit = unit;
        this.delayTicks = unit.toMillis(this.delay) / 50L;
        this.periodTicks = unit.toMillis(this.period) / 50L;
        this.fromTicks = fromTicks;
    }

    public static TimerTaskTime of(long delay, long period, TimeUnit unit) {
        return new TimerTaskTime(delay, period, unit, false);
    }

    public static TimerTaskTime of(long delayTicks, long periodTicks) {
        return new TimerTaskTime(delayTicks * 50L, periodTicks * 50L, TimeUnit.MILLISECONDS, true);
    }

    public long getDelay() {
        return this.delay;
    }

    public long getNormalizedDelay() {
        if (this.delay <= 0L) {
            return this.fromTicks ? 50L : 1L;
        }
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    public long getNormalizedPeriod() {
        if (this.period <= 0L) {
            return this.fromTicks ? 50L : 1L;
        }
        return this.period;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getDelayTicks() {
        return this.delayTicks;
    }

    public long getNormalizedDelayTicks() {
        return Math.max(1L, this.delayTicks);
    }

    public long getPeriodTicks() {
        return this.periodTicks;
    }

    public long getNormalizedPeriodTicks() {
        return Math.max(1L, this.periodTicks);
    }
}

