/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.hscore.bukkit.scheduler.Runner;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.TaskTime;
import me.hsgamer.hscore.bukkit.scheduler.TimerTaskTime;
import me.hsgamer.hscore.bukkit.scheduler.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

class FoliaAsyncRunner
implements Runner {
    private final FoliaScheduler scheduler;

    FoliaAsyncRunner(FoliaScheduler scheduler) {
        this.scheduler = scheduler;
    }

    private void addTask(ScheduledTask task) {
        this.scheduler.addTask(task);
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(Entity entity, BooleanSupplier runnable, Runnable retired) {
        return scheduledTask -> {
            if (FoliaScheduler.isEntityValid(entity)) {
                if (!runnable.getAsBoolean()) {
                    scheduledTask.cancel();
                }
            } else {
                retired.run();
                scheduledTask.cancel();
            }
        };
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(Entity entity, Runnable runnable, Runnable retired) {
        return this.wrapEntityRunnable(entity, () -> {
            runnable.run();
            return true;
        }, retired);
    }

    private Task scheduleTask(Consumer<ScheduledTask> consumer) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), consumer);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    private Task scheduleTaskLater(Consumer<ScheduledTask> consumer, TaskTime delay) {
        long time = delay.getTime();
        ScheduledTask task = time > 0L ? Bukkit.getAsyncScheduler().runDelayed(this.scheduler.getPlugin(), consumer, time, delay.getUnit()) : Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), consumer);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    private Task scheduleTaskTimer(Consumer<ScheduledTask> consumer, TimerTaskTime timerTaskTime) {
        long delay = timerTaskTime.getDelay();
        long period = timerTaskTime.getNormalizedPeriod();
        ScheduledTask task = delay > 0L ? Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), consumer, delay, period, timerTaskTime.getUnit()) : Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), consumer, 1L, timerTaskTime.getUnit().toMillis(period), TimeUnit.MILLISECONDS);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runTask(Runnable runnable) {
        return this.scheduleTask(FoliaScheduler.wrapRunnable(runnable));
    }

    @Override
    public Task runTaskLater(Runnable runnable, TaskTime delay) {
        return this.scheduleTaskLater(FoliaScheduler.wrapRunnable(runnable), delay);
    }

    @Override
    public Task runTaskTimer(BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        return this.scheduleTaskTimer(FoliaScheduler.wrapRunnable(runnable), timerTaskTime);
    }

    @Override
    public Task runEntityTask(Entity entity, Runnable runnable, Runnable retired) {
        return this.scheduleTask(this.wrapEntityRunnable(entity, runnable, retired));
    }

    @Override
    public Task runEntityTaskLater(Entity entity, Runnable runnable, Runnable retired, TaskTime delay) {
        return this.scheduleTaskLater(this.wrapEntityRunnable(entity, runnable, retired), delay);
    }

    @Override
    public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, Runnable retired, TimerTaskTime timerTaskTime) {
        return this.scheduleTaskTimer(this.wrapEntityRunnable(entity, runnable, retired), timerTaskTime);
    }

    @Override
    public Task runLocationTask(Location location, Runnable runnable) {
        return this.runTask(runnable);
    }

    @Override
    public Task runLocationTaskLater(Location location, Runnable runnable, TaskTime delay) {
        return this.runTaskLater(runnable, delay);
    }

    @Override
    public Task runLocationTaskTimer(Location location, BooleanSupplier runnable, TimerTaskTime timerTaskTime) {
        return this.runTaskTimer(runnable, timerTaskTime);
    }
}

