/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler;

import java.util.function.BooleanSupplier;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public interface Runner {
    public Task runTask(Runnable var1);

    public Task runTaskLater(Runnable var1, long var2);

    public Task runTaskTimer(BooleanSupplier var1, long var2, long var4);

    default public Task runTaskTimer(Runnable runnable, long delay, long period) {
        return this.runTaskTimer(() -> {
            runnable.run();
            return true;
        }, delay, period);
    }

    public Task runEntityTask(Entity var1, Runnable var2, Runnable var3);

    public Task runEntityTaskLater(Entity var1, Runnable var2, Runnable var3, long var4);

    public Task runEntityTaskTimer(Entity var1, BooleanSupplier var2, Runnable var3, long var4, long var6);

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, Runnable retired, long delay, long period) {
        return this.runEntityTaskTimer(entity, () -> {
            runnable.run();
            return true;
        }, retired, delay, period);
    }

    default public Task runEntityTask(Entity entity, Runnable runnable) {
        return this.runEntityTask(entity, runnable, () -> {});
    }

    default public Task runEntityTaskLater(Entity entity, Runnable runnable, long delay) {
        return this.runEntityTaskLater(entity, runnable, () -> {}, delay);
    }

    default public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, long delay, long period) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, delay, period);
    }

    default public Task runEntityTaskTimer(Entity entity, Runnable runnable, long delay, long period) {
        return this.runEntityTaskTimer(entity, runnable, () -> {}, delay, period);
    }

    default public Task runEntityTaskWithFinalizer(Entity entity, Runnable runnable, Runnable finalizer) {
        return this.runEntityTask(entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer);
    }

    default public Task runEntityTaskLaterWithFinalizer(Entity entity, Runnable runnable, Runnable finalizer, long delay) {
        return this.runEntityTaskLater(entity, () -> {
            try {
                runnable.run();
            }
            finally {
                finalizer.run();
            }
        }, finalizer, delay);
    }

    public Task runLocationTask(Location var1, Runnable var2);

    public Task runLocationTaskLater(Location var1, Runnable var2, long var3);

    public Task runLocationTaskTimer(Location var1, BooleanSupplier var2, long var3, long var5);

    default public Task runLocationTaskTimer(Location location, Runnable runnable, long delay, long period) {
        return this.runLocationTaskTimer(location, () -> {
            runnable.run();
            return true;
        }, delay, period);
    }
}

