/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.scheduler.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.hscore.bukkit.scheduler.Runner;
import me.hsgamer.hscore.bukkit.scheduler.Task;
import me.hsgamer.hscore.bukkit.scheduler.folia.FoliaScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

class FoliaAsyncRunner
implements Runner {
    private final FoliaScheduler scheduler;

    FoliaAsyncRunner(FoliaScheduler scheduler) {
        this.scheduler = scheduler;
    }

    private void addTask(ScheduledTask task) {
        this.scheduler.addTask(task);
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(Entity entity, BooleanSupplier runnable, Runnable retired) {
        return scheduledTask -> {
            if (FoliaScheduler.isEntityValid(entity)) {
                if (!runnable.getAsBoolean()) {
                    scheduledTask.cancel();
                }
            } else {
                retired.run();
                scheduledTask.cancel();
            }
        };
    }

    private Consumer<ScheduledTask> wrapEntityRunnable(Entity entity, Runnable runnable, Runnable retired) {
        return this.wrapEntityRunnable(entity, () -> {
            runnable.run();
            return true;
        }, retired);
    }

    @Override
    public Task runTask(Runnable runnable) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runTaskLater(Runnable runnable, long delay) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runDelayed(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), FoliaScheduler.toMilliSecond(delay), TimeUnit.MILLISECONDS);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runTaskTimer(BooleanSupplier runnable, long delay, long period) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), FoliaScheduler.wrapRunnable(runnable), FoliaScheduler.toMilliSecond(delay), FoliaScheduler.toMilliSecond(period), TimeUnit.MILLISECONDS);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTask(Entity entity, Runnable runnable, Runnable retired) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired));
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTaskLater(Entity entity, Runnable runnable, Runnable retired, long delay) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runDelayed(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired), FoliaScheduler.toMilliSecond(delay), TimeUnit.MILLISECONDS);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runEntityTaskTimer(Entity entity, BooleanSupplier runnable, Runnable retired, long delay, long period) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.scheduler.getPlugin(), this.wrapEntityRunnable(entity, runnable, retired), FoliaScheduler.toMilliSecond(delay), FoliaScheduler.toMilliSecond(period), TimeUnit.MILLISECONDS);
        this.addTask(task);
        return FoliaScheduler.wrapTask(task, true);
    }

    @Override
    public Task runLocationTask(Location location, Runnable runnable) {
        return this.runTask(runnable);
    }

    @Override
    public Task runLocationTaskLater(Location location, Runnable runnable, long delay) {
        return this.runTaskLater(runnable, delay);
    }

    @Override
    public Task runLocationTaskTimer(Location location, BooleanSupplier runnable, long delay, long period) {
        return this.runTaskTimer(runnable, delay, period);
    }
}

