/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.skull;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.skull.SkullHandler;
import me.hsgamer.hscore.bukkit.utils.VersionUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.SkullMeta;

class OldSkullHandler
implements SkullHandler {
    private final Method getProfileMethod;

    OldSkullHandler() {
        Method method = null;
        try {
            method = Property.class.getDeclaredMethod("value", new Class[0]);
        }
        catch (Exception e) {
            try {
                method = Property.class.getDeclaredMethod("getValue", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.getProfileMethod = method;
    }

    @Override
    public void setSkullByPlayer(SkullMeta meta, OfflinePlayer player) {
        if (VersionUtils.isAtLeast((int)12)) {
            meta.setOwningPlayer(player);
        } else {
            meta.setOwner(player.getName());
        }
    }

    @Override
    public void setSkullByURL(SkullMeta meta, URL url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64.getEncoder().encodeToString(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes())));
        try {
            Method setProfile = meta.getClass().getMethod("setProfile", GameProfile.class);
            setProfile.setAccessible(true);
            setProfile.invoke((Object)meta, profile);
        }
        catch (Exception e) {
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getSkullValue(SkullMeta meta) {
        GameProfile profile;
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
        }
        catch (Exception e) {
            return "";
        }
        Collection properties = profile.getProperties().get((Object)"textures");
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        for (Property property : properties) {
            String value;
            try {
                value = (String)this.getProfileMethod.invoke((Object)property, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (value.isEmpty()) continue;
            return value;
        }
        return "";
    }

    @Override
    public boolean compareSkull(SkullMeta meta1, SkullMeta meta2) {
        return this.getSkullValue(meta1).equals(this.getSkullValue(meta2));
    }
}

