/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.variable;

import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.utils.BukkitUtils;
import me.hsgamer.hscore.common.StringReplacer;
import me.hsgamer.hscore.variable.VariableBundle;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public final class BukkitVariableBundle {
    private BukkitVariableBundle() {
    }

    public static void registerVariables(VariableBundle bundle) {
        bundle.register("player", StringReplacer.of((original, uuid) -> Bukkit.getOfflinePlayer((UUID)uuid).getName()), true);
        bundle.register("online", StringReplacer.of(original -> String.valueOf(Bukkit.getOnlinePlayers().size())), true);
        bundle.register("max_players", StringReplacer.of(original -> String.valueOf(Bukkit.getMaxPlayers())), true);
        bundle.register("world", StringReplacer.of((original, uuid) -> {
            Optional<World> optional = Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(player -> player.getLocation().getWorld());
            if (original.equalsIgnoreCase("_env")) {
                return optional.map(World::getEnvironment).map(Enum::name).orElse("");
            }
            if (original.isEmpty()) {
                return optional.map(World::getName).orElse("");
            }
            return null;
        }));
        bundle.register("x", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Entity::getLocation).map(Location::getX).map(String::valueOf).orElse("")), true);
        bundle.register("y", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Entity::getLocation).map(Location::getY).map(String::valueOf).orElse("")), true);
        bundle.register("z", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Entity::getLocation).map(Location::getZ).map(String::valueOf).orElse("")), true);
        bundle.register("bed_", StringReplacer.of((original, uuid) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || player.getBedSpawnLocation() == null) {
                return "";
            }
            if (original.equalsIgnoreCase("world")) {
                return player.getBedSpawnLocation().getWorld().getName();
            }
            if (original.equalsIgnoreCase("x")) {
                return String.valueOf(player.getBedSpawnLocation().getX());
            }
            if (original.equalsIgnoreCase("y")) {
                return String.valueOf(player.getBedSpawnLocation().getY());
            }
            if (original.equalsIgnoreCase("z")) {
                return String.valueOf(player.getBedSpawnLocation().getZ());
            }
            if (original.equalsIgnoreCase("world_env")) {
                return player.getBedSpawnLocation().getWorld().getEnvironment().name();
            }
            return null;
        }));
        bundle.register("exp", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Player::getExp).map(String::valueOf).orElse("")), true);
        bundle.register("level", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Player::getLevel).map(String::valueOf).orElse("")), true);
        bundle.register("exp_to_level", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(HumanEntity::getExpToLevel).map(String::valueOf).orElse("")), true);
        bundle.register("food_level", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Player::getFoodLevel).map(String::valueOf).orElse("")), true);
        bundle.register("ip", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Player::getAddress).map(address -> address.getAddress().getHostName()).orElse("")), true);
        bundle.register("biome", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(Entity::getLocation).map(Location::getBlock).map(block -> block.getBiome().name()).orElse("")), true);
        bundle.register("ping", StringReplacer.of((original, uuid) -> Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).map(BukkitUtils::getPing).map(String::valueOf).orElse("")), true);
    }
}

