/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.github;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GithubCommitChecker
implements VersionChecker {
    private final JSONParser parser = new JSONParser();
    private final String url;
    private final UserAgent userAgent;

    public GithubCommitChecker(String repo, String branch, UserAgent userAgent) {
        this.userAgent = userAgent;
        this.url = "https://api.github.com/repos/" + repo + "/commits/heads/" + branch;
    }

    public GithubCommitChecker(String repo, String branch) {
        this(repo, branch, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = this.userAgent.assignToConnection(WebUtils.createConnection((String)this.url)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    Object object = this.parser.parse((Reader)reader);
                    if (!(object instanceof JSONObject)) {
                        throw new IOException("The response is not a JSON object");
                    }
                    JSONObject jsonObject = (JSONObject)object;
                    string = Objects.toString(jsonObject.get((Object)"sha"));
                }
                return string;
            }
            catch (IOException | ParseException e) {
                throw new CompletionException(e);
            }
        });
    }
}

