/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.github;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GithubReleaseChecker
implements VersionChecker {
    private final JSONParser parser = new JSONParser();
    private final String url;
    private final UserAgent userAgent;

    public GithubReleaseChecker(String repo, UserAgent userAgent) {
        this.url = "https://api.github.com/repos/" + repo + "/releases?per_page=1";
        this.userAgent = userAgent;
    }

    public GithubReleaseChecker(String repo) {
        this(repo, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection((String)this.url, arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    Object object = this.parser.parse((Reader)reader);
                    if (!(object instanceof JSONArray)) {
                        throw new IOException("The response is not a JSON array");
                    }
                    JSONArray array = (JSONArray)object;
                    if (array.isEmpty()) {
                        throw new IOException("The response is empty");
                    }
                    Object first = array.get(0);
                    if (!(first instanceof JSONObject)) {
                        throw new IOException("The first element is not a JSON object");
                    }
                    JSONObject jsonObject = (JSONObject)first;
                    string = Objects.toString(jsonObject.get((Object)"tag_name"));
                }
                return string;
            }
            catch (IOException | ParseException e) {
                throw new CompletionException(e);
            }
        });
    }
}

