/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.github;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;

public class GithubCommitChecker
implements VersionChecker {
    private final String url;
    private final UserAgent userAgent;

    public GithubCommitChecker(String repo, String branch, UserAgent userAgent) {
        this.userAgent = userAgent;
        this.url = "https://api.github.com/repos/" + repo + "/commits/heads/" + branch;
    }

    public GithubCommitChecker(String repo, String branch) {
        this(repo, branch, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection((String)this.url, arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonElement element = new JsonParser().parse((Reader)reader);
                    if (!element.isJsonObject()) {
                        throw new IOException("The response is null");
                    }
                    JsonElement sha = element.getAsJsonObject().get("sha");
                    if (sha == null) {
                        throw new IOException("The response is null");
                    }
                    string = sha.getAsString();
                }
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

