/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;

public class GithubReleaseChecker
implements VersionChecker {
    private final String url;
    private final UserAgent userAgent;

    public GithubReleaseChecker(String repo, UserAgent userAgent) {
        this.url = "https://api.github.com/repos/" + repo + "/releases?per_page=1";
        this.userAgent = userAgent;
    }

    public GithubReleaseChecker(String repo) {
        this(repo, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection((String)this.url, arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    if (!element.isJsonArray()) {
                        throw new IOException("The response is not a JSON array");
                    }
                    JsonArray array = element.getAsJsonArray();
                    if (array.isEmpty()) {
                        throw new IOException("The response is empty");
                    }
                    JsonElement first = array.get(0);
                    if (!first.isJsonObject()) {
                        throw new IOException("The first element is not a JSON object");
                    }
                    JsonElement tag = first.getAsJsonObject().get("tag_name");
                    if (tag == null) {
                        throw new IOException("The tag name is null");
                    }
                    string = tag.getAsString();
                }
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

