/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.modrinth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;

public class ModrinthVersionChecker
implements VersionChecker {
    private final String id;
    private final List<String> loaders;
    private final List<String> gameVersions;
    private final boolean featured;
    private final UserAgent userAgent;

    public ModrinthVersionChecker(String id, List<String> loaders, List<String> gameVersions, boolean featured, UserAgent userAgent) {
        this.id = id;
        this.loaders = loaders;
        this.gameVersions = gameVersions;
        this.featured = featured;
        this.userAgent = userAgent;
    }

    public ModrinthVersionChecker(String id, List<String> loaders, List<String> gameVersions, boolean featured) {
        this(id, loaders, gameVersions, featured, new UserAgent(id));
    }

    public ModrinthVersionChecker(String id, UserAgent userAgent) {
        this(id, Collections.emptyList(), Collections.emptyList(), true, userAgent);
    }

    public ModrinthVersionChecker(String id) {
        this(id, new UserAgent(id));
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        StringBuilder urlBuilder = new StringBuilder("https://api.modrinth.com/api/v1/mod/" + this.id + "/version");
        urlBuilder.append("?loaders=[").append(String.join((CharSequence)",", this.loaders)).append("]");
        urlBuilder.append("&game_versions=[").append(String.join((CharSequence)",", this.gameVersions)).append("]");
        urlBuilder.append("&featured=").append(this.featured);
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection((String)urlBuilder.toString(), arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    if (!element.isJsonArray()) {
                        throw new IOException("Invalid JSON");
                    }
                    JsonArray array = element.getAsJsonArray();
                    if (array.isEmpty()) {
                        throw new IOException("The response is empty");
                    }
                    JsonElement first = array.get(0);
                    if (!first.isJsonObject()) {
                        throw new IOException("The first element is not a JSON object");
                    }
                    JsonElement versionElement = first.getAsJsonObject().get("version_number");
                    if (versionElement == null) {
                        throw new IOException("The version number is not a primitive");
                    }
                    string = versionElement.getAsString();
                }
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

