/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.spigotmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class SpigotVersionChecker
implements VersionChecker {
    private final JSONParser parser = new JSONParser();
    private final int resourceId;
    private final UserAgent userAgent;

    public SpigotVersionChecker(int resourceId, UserAgent userAgent) {
        this.resourceId = resourceId;
        this.userAgent = userAgent;
    }

    public SpigotVersionChecker(int resourceId) {
        this(resourceId, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = this.userAgent.assignToConnection(WebUtils.createConnection((String)("https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=" + this.resourceId))).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    Object object = this.parser.parse((Reader)reader);
                    if (!(object instanceof JSONObject)) {
                        throw new IOException("Invalid JSON");
                    }
                    JSONObject jsonObject = (JSONObject)object;
                    if (!jsonObject.containsKey((Object)"current_version")) {
                        throw new IOException("Cannot get the plugin version");
                    }
                    string = Objects.toString(jsonObject.get((Object)"current_version"));
                }
                return string;
            }
            catch (IOException | ParseException exception) {
                throw new IllegalStateException(exception);
            }
        });
    }
}

