/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.checker.spigotmc;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.checker.VersionChecker;
import me.hsgamer.hscore.gson.GsonUtils;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.jetbrains.annotations.NotNull;

public final class SpigotVersionChecker
implements VersionChecker {
    private final int resourceId;
    private final UserAgent userAgent;

    public SpigotVersionChecker(int resourceId, UserAgent userAgent) {
        this.resourceId = resourceId;
        this.userAgent = userAgent;
    }

    public SpigotVersionChecker(int resourceId) {
        this(resourceId, UserAgent.FIREFOX);
    }

    @NotNull
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream inputStream = WebUtils.createConnection((String)("https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=" + this.resourceId), arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream();){
                String string;
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    JsonElement element = GsonUtils.parse((Reader)reader);
                    if (!element.isJsonObject()) {
                        throw new IOException("Invalid JSON");
                    }
                    JsonElement currentVersion = element.getAsJsonObject().get("current_version");
                    if (currentVersion == null) {
                        throw new IOException("Cannot get the plugin version");
                    }
                    string = currentVersion.getAsString();
                }
                return string;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

