/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @NotNull
    public static List<String> createStringListFromObject(@NotNull Object value, boolean trim) {
        ArrayList<String> list = new ArrayList<String>();
        if (value instanceof Collection) {
            ((Collection)value).forEach(o -> list.add(String.valueOf(o)));
        } else {
            list.add(String.valueOf(value));
        }
        if (trim) {
            list.replaceAll(String::trim);
        }
        return list;
    }

    @NotNull
    public static List<String> createStringListFromObject(@NotNull Object value) {
        return CollectionUtils.createStringListFromObject(value, false);
    }

    @NotNull
    public static <T> List<T> reverse(@NotNull Collection<T> original) {
        ArrayList<T> list = new ArrayList<T>(original);
        Collections.reverse(list);
        return list;
    }

    @NotNull
    public static <T> List<T> rotate(@NotNull Collection<T> original, int distance) {
        ArrayList<T> list = new ArrayList<T>(original);
        Collections.rotate(list, distance);
        return list;
    }

    @NotNull
    public static <T> List<T> repeatElement(@NotNull Collection<T> original, int repeat) {
        ArrayList list = new ArrayList();
        for (Object element : original) {
            list.addAll(IntStream.range(0, repeat).mapToObj(i -> element).collect(Collectors.toList()));
        }
        return list;
    }

    @NotNull
    public static <T> List<T> repeatCollection(@NotNull Collection<T> original, int repeat) {
        ArrayList list = new ArrayList();
        IntStream.range(0, repeat).mapToObj(i -> original).forEach(list::addAll);
        return list;
    }

    @NotNull
    public static List<String> splitAll(@NotNull String regex, @NotNull Collection<String> strings) {
        return strings.stream().flatMap(s -> Stream.of(s.split(regex))).collect(Collectors.toList());
    }

    @Nullable
    public static <T> T pickRandom(@NotNull Collection<T> collection, @NotNull Predicate<T> matchCondition) {
        ArrayList<T> list = new ArrayList<T>(collection);
        T picked = null;
        while (!list.isEmpty()) {
            int index = ThreadLocalRandom.current().nextInt(list.size());
            Object element = list.get(index);
            if (matchCondition.test(element)) {
                picked = (T)element;
                break;
            }
            list.remove(index);
        }
        return picked;
    }

    @Nullable
    public static <T> T pickRandom(@NotNull Collection<T> collection) {
        return (T)CollectionUtils.pickRandom(collection, (T t) -> true);
    }

    @Nullable
    public static <T> T pickRandom(@NotNull T[] array, @NotNull Predicate<T> matchCondition) {
        return CollectionUtils.pickRandom(Arrays.asList(array), matchCondition);
    }

    @Nullable
    public static <T> T pickRandom(@NotNull T[] array) {
        return CollectionUtils.pickRandom(Arrays.asList(array));
    }
}

