/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    private static final Pattern hexPattern = Pattern.compile("(\\\\?)((\\S)#([A-Fa-f\\d]{1,6}))");

    private StringUtils() {
    }

    public static String replacePattern(@NotNull String input, @NotNull Pattern pattern, @NotNull @NotNull Function<@NotNull Matcher, @Nullable String> replacementFunction) {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input.length() + 32);
        do {
            String replacement;
            if ((replacement = replacementFunction.apply(matcher)) == null) continue;
            matcher.appendReplacement(buffer, replacement);
        } while (matcher.find());
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    @NotNull
    public static String replaceChar(char altChar, char finalChar, @NotNull String input, @NotNull Map<Character, Supplier<Character>> charMappers) {
        int inputIndex;
        if (input.indexOf(altChar) < 0) {
            return input;
        }
        char[] chars = input.toCharArray();
        int outputIndex = 0;
        for (inputIndex = 0; inputIndex < chars.length - 1; ++inputIndex) {
            if (chars[inputIndex] == altChar && Character.isLetterOrDigit(chars[inputIndex + 1])) {
                char currentChar;
                chars[outputIndex++] = finalChar;
                chars[outputIndex++] = charMappers.containsKey(Character.valueOf(currentChar = Character.toLowerCase(chars[++inputIndex]))) ? charMappers.get(Character.valueOf(currentChar)).get().charValue() : currentChar;
                if (inputIndex + 1 >= chars.length || !Character.isWhitespace(chars[inputIndex + 1])) continue;
                ++inputIndex;
                continue;
            }
            chars[outputIndex++] = chars[inputIndex] == '\\' && chars[inputIndex + 1] == altChar ? chars[++inputIndex] : chars[inputIndex];
        }
        if (inputIndex == chars.length - 1) {
            chars[outputIndex++] = chars[inputIndex];
        }
        return new String(chars, 0, Math.min(outputIndex, chars.length));
    }

    @NotNull
    public static String replaceHex(char indicator, @NotNull Function<char[], String> replacer, @NotNull String input) {
        return StringUtils.replacePattern(input, hexPattern, matcher -> {
            String matchedChar = matcher.group(3);
            if (matchedChar.indexOf(indicator) < 0) {
                return null;
            }
            boolean skip = matcher.group(1).equals("\\");
            if (skip) {
                return matcher.group(2);
            }
            char[] hex = StringUtils.normalizeHex(matcher.group(4));
            return (String)replacer.apply(hex);
        });
    }

    public static char[] normalizeHex(@NotNull String input) {
        char[] chars = new char[6];
        switch (input.length()) {
            case 0: {
                chars[0] = 48;
                chars[1] = 48;
                chars[2] = 48;
                chars[3] = 48;
                chars[4] = 48;
                chars[5] = 48;
                break;
            }
            case 1: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(0);
                chars[2] = input.charAt(0);
                chars[3] = input.charAt(0);
                chars[4] = input.charAt(0);
                chars[5] = input.charAt(0);
                break;
            }
            case 2: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(1);
                chars[2] = input.charAt(0);
                chars[3] = input.charAt(1);
                chars[4] = input.charAt(0);
                chars[5] = input.charAt(1);
                break;
            }
            case 3: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(0);
                chars[2] = input.charAt(1);
                chars[3] = input.charAt(1);
                chars[4] = input.charAt(2);
                chars[5] = input.charAt(2);
                break;
            }
            case 4: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(0);
                chars[2] = input.charAt(1);
                chars[3] = input.charAt(1);
                chars[4] = input.charAt(2);
                chars[5] = input.charAt(3);
                break;
            }
            case 5: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(1);
                chars[2] = input.charAt(2);
                chars[3] = input.charAt(3);
                chars[4] = 48;
                chars[5] = input.charAt(4);
                break;
            }
            default: {
                chars[0] = input.charAt(0);
                chars[1] = input.charAt(1);
                chars[2] = input.charAt(2);
                chars[3] = input.charAt(3);
                chars[4] = input.charAt(4);
                chars[5] = input.charAt(5);
            }
        }
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = Character.toLowerCase(chars[i]);
            if (chars[i] >= '0' && chars[i] <= '9' || chars[i] >= 'a' && chars[i] <= 'f') continue;
            chars[i] = 48;
        }
        return chars;
    }
}

