/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Validate {
    private Validate() {
    }

    @NotNull
    public static Optional<BigDecimal> getNumber(@NotNull String input) {
        try {
            return Optional.of(new BigDecimal(input));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static boolean isValidPositiveNumber(@NotNull String input) {
        Optional<BigDecimal> number = Validate.getNumber(input);
        return number.filter(bigDecimal -> bigDecimal.compareTo(BigDecimal.ZERO) > 0).isPresent();
    }

    public static boolean isValidInteger(@NotNull String input) {
        return Validate.getNumber(input).isPresent();
    }

    public static boolean isClassLoaded(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMethodLoaded(@NotNull String className, @NotNull String methodName, Class<?> ... params) {
        try {
            Class.forName(className).getDeclaredMethod(methodName, params);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isConstructorLoaded(@NotNull String className, Class<?> ... params) {
        try {
            Class.forName(className).getDeclaredConstructor(params);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isValidURL(String string) {
        try {
            new URL(string).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidUUID(String string) {
        return string.matches("[\\da-f]{8}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{12}");
    }

    public static boolean isValidBase64(String string) {
        try {
            Base64.getDecoder().decode(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

