/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CachedValue<T> {
    private final AtomicReference<T> cache = new AtomicReference();
    private final AtomicBoolean isCached = new AtomicBoolean(false);

    public T getValue() {
        if (this.isCached.get()) {
            return this.cache.get();
        }
        T value = this.generate();
        this.cache.set(value);
        this.isCached.set(true);
        return value;
    }

    public void clearCache() {
        this.cache.set(null);
        this.isCached.set(false);
    }

    public abstract T generate();
}

