/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public interface StringReplacer {
    public static final StringReplacer DUMMY = (original, uuid) -> original;

    public static String replace(String original, UUID uuid, Collection<? extends StringReplacer> stringReplacers) {
        String replaced = original;
        for (StringReplacer stringReplacer : stringReplacers) {
            replaced = stringReplacer.replace(replaced, uuid);
        }
        return replaced;
    }

    public static String replace(String original, UUID uuid, StringReplacer ... stringReplacers) {
        return StringReplacer.replace(original, uuid, Arrays.asList(stringReplacers));
    }

    public String replace(String var1, UUID var2);

    default public String replace(String original) {
        return this.replace(original, UUID.randomUUID());
    }
}

