/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.util.function.Supplier;

public abstract class CachedValue<T>
implements Supplier<T> {
    private volatile T cache;
    private volatile boolean isCached = false;

    public static <T> CachedValue<T> of(final Supplier<T> supplier) {
        return new CachedValue<T>(){

            @Override
            public T generate() {
                return supplier.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        if (!this.isCached) {
            CachedValue cachedValue = this;
            synchronized (cachedValue) {
                if (!this.isCached) {
                    this.cache = this.generate();
                    this.isCached = true;
                }
            }
        }
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.isCached) {
            CachedValue cachedValue = this;
            synchronized (cachedValue) {
                if (this.isCached) {
                    this.cache = null;
                    this.isCached = false;
                }
            }
        }
    }

    public abstract T generate();

    @Override
    public T get() {
        return this.getValue();
    }
}

