/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MapUtils {
    private MapUtils() {
    }

    @SafeVarargs
    public static <K, V> V getIfFoundOrDefault(Map<K, V> map, V defaultValue, K ... key) {
        for (K k : key) {
            if (!map.containsKey(k)) continue;
            return map.get(k);
        }
        return defaultValue;
    }

    @SafeVarargs
    public static <K, V> V getIfFound(Map<K, V> map, K ... key) {
        return MapUtils.getIfFoundOrDefault(map, null, key);
    }

    @SafeVarargs
    public static <K> boolean containsAnyKey(Map<K, ?> map, K ... key) {
        for (K k : key) {
            if (!map.containsKey(k)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Map<String, Object>> castOptionalStringObjectMap(Object object, boolean unsafe) {
        if (object instanceof Map) {
            if (unsafe) {
                try {
                    return Optional.of((Map)object);
                }
                catch (Throwable throwable) {
                }
            } else {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    map.put(Objects.toString(entry.getKey()), entry.getValue());
                }
                return Optional.of(map);
            }
        }
        return Optional.empty();
    }

    public static Optional<Map<String, Object>> castOptionalStringObjectMap(Object object) {
        return MapUtils.castOptionalStringObjectMap(object, true);
    }
}

