/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.annotated;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.DecorativeConfig;
import me.hsgamer.hscore.config.annotation.Comment;
import me.hsgamer.hscore.config.annotation.ConfigPath;
import me.hsgamer.hscore.config.annotation.converter.Converter;

public class AnnotatedConfig
extends DecorativeConfig {
    private final Map<String, Field> pathFieldMap = new HashMap<String, Field>();

    public AnnotatedConfig(Config config) {
        super(config);
    }

    public void setup() {
        super.setup();
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!this.checkPathField(field)) continue;
            ConfigPath configPath = field.getAnnotation(ConfigPath.class);
            this.pathFieldMap.put(configPath.value(), field);
            validFields.add(field);
        }
        validFields.forEach(this::setupField);
        this.setupClassComment();
        this.save();
    }

    public void set(String path, Object value) {
        Field field = this.pathFieldMap.get(path);
        if (field == null) {
            super.set(path, value);
            return;
        }
        this.checkAndSetField(field, value);
    }

    public void reload() {
        super.reload();
        for (Field field : this.pathFieldMap.values()) {
            this.setupField(field);
        }
        this.setupClassComment();
        this.save();
    }

    private void setupClassComment() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(Comment.class) && this.getComment("") == null) {
            this.setComment("", ((Object)((Object)this)).getClass().getAnnotation(Comment.class).value());
        }
    }

    private boolean checkPathField(Field field) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        if (configPath == null) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
            LOGGER.warning(() -> field.getName() + " is a static final field. Ignored");
            return false;
        }
        try {
            Converter.createConverterSafe((Class)configPath.converter());
        }
        catch (Exception e) {
            LOGGER.warning(() -> "Cannot create a converter for " + field.getName() + ". Ignored");
            return false;
        }
        return true;
    }

    private void setupField(Field field) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        String path = configPath.value();
        Converter converter = Converter.createConverterSafe((Class)configPath.converter());
        Object defaultValue = this.getValue(field);
        if (!this.contains(path)) {
            super.set(path, converter.convertToRaw(defaultValue));
            if (field.isAnnotationPresent(Comment.class)) {
                super.setComment(path, field.getAnnotation(Comment.class).value());
            }
        } else {
            this.setValue(field, converter.convert(this.getNormalized(path)));
        }
    }

    private void checkAndSetField(Field field, Object value) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        String path = configPath.value();
        Converter converter = Converter.createConverterSafe((Class)configPath.converter());
        super.set(path, converter.convertToRaw(value));
        this.setValue(field, value);
    }

    private void setValue(Field field, Object value) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set((Object)this, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set the value for " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private Object getValue(Field field) {
        Object value;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            value = field.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot get the value for " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return value;
    }
}

