/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.annotated;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.DecorativeConfig;
import me.hsgamer.hscore.config.annotation.Comment;
import me.hsgamer.hscore.config.annotation.ConfigPath;
import me.hsgamer.hscore.config.annotation.converter.Converter;
import me.hsgamer.hscore.config.annotation.converter.manager.DefaultConverterManager;
import me.hsgamer.hscore.logger.common.LogLevel;

public class AnnotatedConfig
extends DecorativeConfig {
    private final Map<PathString, Field> pathFieldMap = new HashMap<PathString, Field>();

    public AnnotatedConfig(Config config) {
        super(config);
    }

    private Field getField(String ... path) {
        return this.pathFieldMap.get(new PathString(path));
    }

    private void setField(Field field, String ... path) {
        this.pathFieldMap.put(new PathString(path), field);
    }

    private boolean containsField(String ... path) {
        return this.pathFieldMap.containsKey(new PathString(path));
    }

    public void setup() {
        super.setup();
        ArrayList validFields = new ArrayList();
        Arrays.stream(((Object)((Object)this)).getClass().getDeclaredFields()).filter(this::checkPathField).sorted(this::compareField).forEach(field -> {
            ConfigPath configPath = field.getAnnotation(ConfigPath.class);
            this.setField((Field)field, configPath.value());
            validFields.add(field);
        });
        validFields.forEach(this::setupField);
        this.setupClassComment();
        this.save();
    }

    public void set(Object value, String ... path) {
        Field field = this.getField(path);
        if (field == null) {
            super.set(value, path);
            return;
        }
        this.checkAndSetField(field, value);
    }

    public void reload() {
        super.reload();
        for (Field field : this.pathFieldMap.values()) {
            this.setupField(field);
        }
        this.setupClassComment();
        this.save();
    }

    private void setupClassComment() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(Comment.class) && this.getComment(new String[0]).isEmpty()) {
            this.setComment(Arrays.asList(((Object)((Object)this)).getClass().getAnnotation(Comment.class).value()), new String[0]);
        }
    }

    private boolean checkPathField(Field field) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        if (configPath == null) {
            return false;
        }
        if (Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
            LOGGER.log(LogLevel.WARN, field.getName() + " is a static final field. Ignored");
            return false;
        }
        return true;
    }

    private int compareField(Field field1, Field field2) {
        ConfigPath configPath1 = field1.getAnnotation(ConfigPath.class);
        ConfigPath configPath2 = field2.getAnnotation(ConfigPath.class);
        return Integer.compare(configPath1.priority(), configPath2.priority());
    }

    private void setupField(Field field) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        String[] path = configPath.value();
        Converter converter = DefaultConverterManager.getConverterIfDefault((Type)field.getGenericType(), (Class)configPath.converter());
        Object defaultValue = this.getValue(field);
        if (!this.contains(path)) {
            super.set(converter.convertToRaw(defaultValue), path);
            if (field.isAnnotationPresent(Comment.class)) {
                super.setComment(Arrays.asList(field.getAnnotation(Comment.class).value()), path);
            }
        } else {
            this.setValue(field, converter.convert(this.getNormalized(path)));
        }
    }

    private void checkAndSetField(Field field, Object value) {
        ConfigPath configPath = field.getAnnotation(ConfigPath.class);
        String[] path = configPath.value();
        Converter converter = DefaultConverterManager.getConverterIfDefault((Type)field.getGenericType(), (Class)configPath.converter());
        super.set(converter.convertToRaw(value), path);
        this.setValue(field, value);
    }

    private void setValue(Field field, Object value) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set((Object)this, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set the value for " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private Object getValue(Field field) {
        Object value;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            value = field.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot get the value for " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
        return value;
    }

    private static class PathString {
        private final String[] path;

        private PathString(String[] path) {
            this.path = path;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PathString that = (PathString)object;
            return Objects.deepEquals(this.path, that.path);
        }

        public int hashCode() {
            return Arrays.hashCode(this.path);
        }
    }
}

