/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.annotation.converter.manager;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.hsgamer.hscore.config.annotation.converter.Converter;
import me.hsgamer.hscore.config.annotation.converter.DefaultConverter;
import me.hsgamer.hscore.config.annotation.converter.PrimitiveConverter;
import me.hsgamer.hscore.config.annotation.converter.SimpleConverter;

public final class DefaultConverterManager {
    private static final Map<Type, Converter> CONVERTER_MAP = new HashMap<Type, Converter>();

    private DefaultConverterManager() {
    }

    public static void registerConverter(Type type, Converter converter) {
        CONVERTER_MAP.put(type, converter);
    }

    public static void unregisterConverter(Type type) {
        CONVERTER_MAP.remove(type);
    }

    public static Converter getConverterIfDefault(Type type, Converter converter) {
        if (converter instanceof DefaultConverter) {
            return CONVERTER_MAP.getOrDefault(type, converter);
        }
        return converter;
    }

    public static Converter getConverterIfDefault(Type type, Class<? extends Converter> converterClass) {
        return DefaultConverterManager.getConverterIfDefault(type, Converter.createConverterSafe(converterClass));
    }

    public static Converter getConverter(Type type) {
        return DefaultConverterManager.getConverterIfDefault(type, new DefaultConverter());
    }

    static {
        DefaultConverterManager.registerConverter(String.class, new SimpleConverter(Objects::toString));
        DefaultConverterManager.registerConverter(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        DefaultConverterManager.registerConverter(Boolean.class, new PrimitiveConverter(Boolean.class));
        DefaultConverterManager.registerConverter(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        DefaultConverterManager.registerConverter(Byte.class, new PrimitiveConverter(Byte.class));
        DefaultConverterManager.registerConverter(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        DefaultConverterManager.registerConverter(Short.class, new PrimitiveConverter(Short.class));
        DefaultConverterManager.registerConverter(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        DefaultConverterManager.registerConverter(Integer.class, new PrimitiveConverter(Integer.class));
        DefaultConverterManager.registerConverter(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        DefaultConverterManager.registerConverter(Long.class, new PrimitiveConverter(Long.class));
        DefaultConverterManager.registerConverter(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        DefaultConverterManager.registerConverter(Float.class, new PrimitiveConverter(Float.class));
        DefaultConverterManager.registerConverter(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        DefaultConverterManager.registerConverter(Double.class, new PrimitiveConverter(Double.class));
        DefaultConverterManager.registerConverter(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        DefaultConverterManager.registerConverter(Character.class, new PrimitiveConverter(Character.class));
        DefaultConverterManager.registerConverter(URI.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                return URI.create(Objects.toString(raw));
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(URL.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new URL(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(BigInteger.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new BigInteger(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(BigDecimal.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new BigDecimal(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(Instant.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return Instant.parse(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
    }
}

