/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.annotation.converter;

import java.util.Objects;
import me.hsgamer.hscore.config.annotation.converter.Converter;

public class PrimitiveConverter
implements Converter {
    private final boolean isPrimitive;
    private final Class<?> boxedClass;

    public PrimitiveConverter(Class<?> clazz) {
        this.isPrimitive = clazz.isPrimitive();
        Class<?> clazz2 = this.boxedClass = this.isPrimitive ? PrimitiveConverter.getBoxedClass(clazz) : clazz;
        if (this.boxedClass == null) {
            throw new IllegalArgumentException("Not a primitive class: " + clazz);
        }
    }

    private static Class<?> getBoxedClass(Class<?> primitiveClass) {
        if (primitiveClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveClass == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveClass == Short.TYPE) {
            return Short.class;
        }
        if (primitiveClass == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveClass == Long.TYPE) {
            return Long.class;
        }
        if (primitiveClass == Float.TYPE) {
            return Float.class;
        }
        if (primitiveClass == Double.TYPE) {
            return Double.class;
        }
        if (primitiveClass == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    @Override
    public Object convert(Object raw) {
        if (raw == null) {
            return null;
        }
        if (this.boxedClass == raw.getClass()) {
            return raw;
        }
        String string = Objects.toString(raw, "");
        if (this.boxedClass == Boolean.class) {
            return this.isPrimitive ? Boolean.parseBoolean(string) : Boolean.valueOf(string);
        }
        if (this.boxedClass == Byte.class) {
            try {
                return this.isPrimitive ? Byte.parseByte(string) : Byte.valueOf(string);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Short.class) {
            try {
                return this.isPrimitive ? Short.parseShort(string) : Short.valueOf(string);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Integer.class) {
            try {
                return this.isPrimitive ? Integer.parseInt(string) : Integer.valueOf(string);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Long.class) {
            try {
                return this.isPrimitive ? Long.parseLong(string) : Long.valueOf(string);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Float.class) {
            try {
                return Float.valueOf(this.isPrimitive ? Float.parseFloat(string) : Float.valueOf(string).floatValue());
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Double.class) {
            try {
                return this.isPrimitive ? Double.parseDouble(string) : Double.valueOf(string);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.boxedClass == Character.class) {
            return Character.valueOf(this.isPrimitive ? string.charAt(0) : Character.valueOf(string.charAt(0)).charValue());
        }
        return null;
    }

    @Override
    public Object convertToRaw(Object value) {
        return value;
    }
}

