/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.annotation.converter.manager;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.hsgamer.hscore.config.annotation.converter.Converter;
import me.hsgamer.hscore.config.annotation.converter.ConverterProvider;
import me.hsgamer.hscore.config.annotation.converter.impl.DefaultConverter;
import me.hsgamer.hscore.config.annotation.converter.impl.PrimitiveConverterProvider;
import me.hsgamer.hscore.config.annotation.converter.impl.SimpleConverter;

public final class DefaultConverterManager {
    private static final List<ConverterProvider> PROVIDERS = new ArrayList<ConverterProvider>();
    private static final Map<Type, Converter> CONVERTER_MAP = new HashMap<Type, Converter>();

    private DefaultConverterManager() {
    }

    public static void registerProvider(ConverterProvider provider) {
        PROVIDERS.add(provider);
    }

    public static void registerConverter(Type type, Converter converter) {
        CONVERTER_MAP.put(type, converter);
    }

    public static void unregisterConverter(Type type) {
        CONVERTER_MAP.remove(type);
    }

    public static Converter getConverterIfDefault(Type type, Converter converter) {
        if (converter instanceof DefaultConverter) {
            return CONVERTER_MAP.computeIfAbsent(type, key -> {
                if (key instanceof Class) {
                    Class clazz = (Class)key;
                    for (ConverterProvider provider : PROVIDERS) {
                        Optional<Converter> optionalConverter = provider.getConverter(clazz);
                        if (!optionalConverter.isPresent()) continue;
                        return optionalConverter.get();
                    }
                }
                return converter;
            });
        }
        return converter;
    }

    public static Converter getConverterIfDefault(Type type, Class<? extends Converter> converterClass) {
        return DefaultConverterManager.getConverterIfDefault(type, Converter.createConverterSafe(converterClass));
    }

    public static Converter getConverter(Type type) {
        return DefaultConverterManager.getConverterIfDefault(type, new DefaultConverter());
    }

    static {
        DefaultConverterManager.registerProvider(new PrimitiveConverterProvider());
        DefaultConverterManager.registerConverter(String.class, new SimpleConverter(Objects::toString));
        DefaultConverterManager.registerConverter(URI.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                return URI.create(Objects.toString(raw));
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(URL.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new URL(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(BigInteger.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new BigInteger(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(BigDecimal.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return new BigDecimal(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
        DefaultConverterManager.registerConverter(Instant.class, new Converter(){

            @Override
            public Object convert(Object raw) {
                if (raw == null) {
                    return null;
                }
                try {
                    return Instant.parse(Objects.toString(raw));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object convertToRaw(Object value) {
                return value == null ? null : value.toString();
            }
        });
    }
}

