/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import me.hsgamer.hscore.config.CommentType;

public interface Config {
    public static final Logger LOGGER = Logger.getLogger(Config.class.getSimpleName());

    public Object getOriginal();

    public Object get(String var1, Object var2);

    public void set(String var1, Object var2);

    default public boolean contains(String path) {
        return this.get(path, null) != null;
    }

    public String getName();

    public Map<String, Object> getValues(String var1, boolean var2);

    public void setup();

    public void save();

    public void reload();

    public Object normalize(Object var1);

    public boolean isNormalizable(Object var1);

    default public void remove(String path) {
        this.set(path, null);
    }

    default public void clear() {
        this.getKeys(false).forEach(this::remove);
    }

    default public Object get(String path) {
        return this.get(path, null);
    }

    default public Object getNormalized(String path, Object def) {
        return this.normalizeObject(this.get(path, def));
    }

    default public Object getNormalized(String path) {
        return this.getNormalized(path, null);
    }

    default public <T> T getInstance(String path, T def, Class<T> type) {
        Object value = this.getNormalized(path, def);
        if (type == String.class) {
            return (T)(value != null ? String.valueOf(value) : def);
        }
        return type.isInstance(value) ? type.cast(value) : def;
    }

    default public <T> T getInstance(String path, Class<T> type) {
        return this.getInstance(path, null, type);
    }

    default public boolean isInstance(String path, Class<?> type) {
        return type.isInstance(this.get(path));
    }

    default public Map<String, Object> getValues(boolean deep) {
        return this.getValues("", deep);
    }

    default public Set<String> getKeys(String path, boolean deep) {
        return this.getValues(path, deep).keySet();
    }

    default public Set<String> getKeys(boolean deep) {
        return this.getKeys("", deep);
    }

    default public Map<String, Object> getNormalizedValues(String path, boolean deep) {
        LinkedHashMap<String, Object> normalized = new LinkedHashMap<String, Object>();
        this.getValues(path, deep).forEach((k, v) -> normalized.put((String)k, this.normalizeObject(v)));
        return normalized;
    }

    default public Object normalizeObject(Object object) {
        ArrayList normalizedValue;
        ArrayList arrayList = normalizedValue = this.isNormalizable(object) ? this.normalize(object) : object;
        if (normalizedValue instanceof Map) {
            ((Map)((Object)normalizedValue)).replaceAll((k, v) -> this.normalizeObject(v));
        } else if (normalizedValue instanceof Collection) {
            ArrayList normalizedList = new ArrayList();
            ((Collection)normalizedValue).forEach(v -> normalizedList.add(this.normalizeObject(v)));
            normalizedValue = normalizedList;
        }
        return normalizedValue;
    }

    default public Map<String, Object> getNormalizedValues(boolean deep) {
        return this.getNormalizedValues("", deep);
    }

    default public void addDefault(String path, Object value) {
        if (!this.contains(path)) {
            this.set(path, value);
        }
    }

    default public void addDefaults(Map<String, Object> map) {
        map.forEach(this::addDefault);
    }

    default public String getComment(String path, CommentType type) {
        return null;
    }

    default public void setComment(String path, String value, CommentType type) {
    }

    default public String getComment(String path) {
        return this.getComment(path, CommentType.BLOCK);
    }

    default public void setComment(String path, String value) {
        this.setComment(path, value, CommentType.BLOCK);
    }
}

