/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PathString {
    public static final PathString ROOT = new PathString(new String[0]);
    private final String[] path;

    public PathString(String ... path) {
        this.path = path;
    }

    public static String toPath(String separator, PathString pathString) {
        return String.join((CharSequence)separator, pathString.getPath());
    }

    public static PathString toPathString(String separator, String path) {
        return new PathString(path.split(Pattern.quote(separator)));
    }

    public static Map<String, Object> toPathMap(String separator, Map<PathString, Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        map.forEach((pathString, object) -> result.put(PathString.toPath(separator, pathString), object));
        return result;
    }

    public static Map<PathString, Object> toPathStringMap(String separator, Map<String, Object> map) {
        LinkedHashMap<PathString, Object> result = new LinkedHashMap<PathString, Object>();
        map.forEach((path, object) -> result.put(PathString.toPathString(separator, path), object));
        return result;
    }

    public String[] getPath() {
        return this.path;
    }

    public Object[] getPathAsObject() {
        return this.path;
    }

    public boolean isRoot() {
        return this.path.length == 0;
    }

    public String getLastPath() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public PathString append(PathString pathString) {
        String[] newPath = new String[this.path.length + pathString.path.length];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        System.arraycopy(pathString.path, 0, newPath, this.path.length, pathString.path.length);
        return new PathString(newPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathString that = (PathString)o;
        return Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }
}

