/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.hsgamer.hscore.config.PathString;

public class CaseInsensitivePathString {
    private final PathString pathString;

    public CaseInsensitivePathString(PathString pathString) {
        this.pathString = pathString;
    }

    public CaseInsensitivePathString(String ... path) {
        this(new PathString(path));
    }

    public static Map<CaseInsensitivePathString, Object> toCaseInsensitiveMap(Map<PathString, Object> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> new CaseInsensitivePathString((PathString)entry.getKey()), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    public PathString getPathString() {
        return this.pathString;
    }

    public String[] getPath() {
        return this.pathString.getPath();
    }

    public boolean equals(Object o) {
        String[] thisPath;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseInsensitivePathString that = (CaseInsensitivePathString)o;
        String[] thatPath = that.pathString.getPath();
        if (thatPath.length != (thisPath = this.pathString.getPath()).length) {
            return false;
        }
        for (int i = 0; i < thatPath.length; ++i) {
            if (thatPath[i].equalsIgnoreCase(thisPath[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String[] thisPath = this.pathString.getPath();
        Object[] lowerPath = new String[thisPath.length];
        for (int i = 0; i < thisPath.length; ++i) {
            lowerPath[i] = thisPath[i].toLowerCase();
        }
        return Objects.hash(lowerPath);
    }
}

