/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;

public interface Config {
    public static final Logger LOGGER = LoggerProvider.getLogger(Config.class);

    public Object getOriginal();

    public Object get(PathString var1, Object var2);

    public void set(PathString var1, Object var2);

    default public boolean contains(PathString path) {
        return this.get(path, null) != null;
    }

    public String getName();

    public Map<PathString, Object> getValues(PathString var1, boolean var2);

    public void setup();

    public void save();

    public void reload();

    public Object normalize(Object var1);

    public boolean isNormalizable(Object var1);

    default public void remove(PathString path) {
        if (path.isRoot()) {
            this.clear();
        } else {
            this.set(path, null);
        }
    }

    default public void clear() {
        this.getKeys(false).forEach(this::remove);
    }

    default public Object get(PathString path) {
        return this.get(path, null);
    }

    default public Object getNormalized(PathString path, Object def) {
        return this.normalizeObject(this.get(path, def));
    }

    default public Object getNormalized(PathString path) {
        return this.getNormalized(path, null);
    }

    default public <T> T getInstance(PathString path, T def, Class<T> type) {
        Object value = this.getNormalized(path, def);
        if (type == String.class) {
            return (T)(value != null ? String.valueOf(value) : def);
        }
        return type.isInstance(value) ? type.cast(value) : def;
    }

    default public <T> T getInstance(PathString path, Class<T> type) {
        return this.getInstance(path, null, type);
    }

    default public boolean isInstance(PathString path, Class<?> type) {
        return type.isInstance(this.get(path));
    }

    default public Map<PathString, Object> getValues(boolean deep) {
        return this.getValues(PathString.ROOT, deep);
    }

    default public Set<PathString> getKeys(PathString path, boolean deep) {
        return this.getValues(path, deep).keySet();
    }

    default public Set<PathString> getKeys(boolean deep) {
        return this.getKeys(PathString.ROOT, deep);
    }

    default public Map<PathString, Object> getNormalizedValues(PathString path, boolean deep) {
        LinkedHashMap<PathString, Object> normalized = new LinkedHashMap<PathString, Object>();
        this.getValues(path, deep).forEach((k, v) -> normalized.put((PathString)k, this.normalizeObject(v)));
        return normalized;
    }

    default public Object normalizeObject(Object object) {
        Cloneable normalizedValue;
        Cloneable cloneable = normalizedValue = this.isNormalizable(object) ? this.normalize(object) : object;
        if (normalizedValue instanceof Map) {
            LinkedHashMap normalizedMap = new LinkedHashMap();
            ((Map)((Object)normalizedValue)).forEach((k, v) -> normalizedMap.put(k, this.normalizeObject(v)));
            normalizedValue = normalizedMap;
        } else if (normalizedValue instanceof Collection) {
            ArrayList normalizedList = new ArrayList();
            ((Collection)((Object)normalizedValue)).forEach(v -> normalizedList.add(this.normalizeObject(v)));
            normalizedValue = normalizedList;
        }
        return normalizedValue;
    }

    default public Map<PathString, Object> getNormalizedValues(boolean deep) {
        return this.getNormalizedValues(PathString.ROOT, deep);
    }

    default public void addDefault(PathString path, Object value) {
        if (!this.contains(path)) {
            this.set(path, value);
        }
    }

    default public void addDefaults(Map<PathString, Object> map) {
        map.forEach(this::addDefault);
    }

    default public List<String> getComment(PathString path, CommentType type) {
        return Collections.emptyList();
    }

    default public void setComment(PathString path, List<String> value, CommentType type) {
    }

    default public List<String> getComment(PathString path) {
        return this.getComment(path, CommentType.BLOCK);
    }

    default public void setComment(PathString path, List<String> value) {
        this.setComment(path, value, CommentType.BLOCK);
    }
}

