/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PathString
implements Comparable<PathString> {
    public static final PathString ROOT = new PathString(new String[0]);
    public static final String DEFAULT_SEPARATOR = ".";
    private final String[] path;

    public PathString(String ... path) {
        this.path = path;
    }

    public static String toPath(String separator, PathString pathString) {
        return String.join((CharSequence)separator, pathString.getPath());
    }

    public static PathString toPathString(String separator, String path) {
        return new PathString(path.split(Pattern.quote(separator)));
    }

    public static Map<String, Object> toPathMap(String separator, Map<PathString, Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<PathString, Object> entry : map.entrySet()) {
            result.put(PathString.toPath(separator, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Map<PathString, Object> toPathStringMap(String separator, Map<String, Object> map) {
        LinkedHashMap<PathString, Object> result = new LinkedHashMap<PathString, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(PathString.toPathString(separator, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static String toPath(PathString pathString) {
        return PathString.toPath(DEFAULT_SEPARATOR, pathString);
    }

    public static PathString toPathString(String path) {
        return PathString.toPathString(DEFAULT_SEPARATOR, path);
    }

    public static Map<String, Object> toPathMap(Map<PathString, Object> map) {
        return PathString.toPathMap(DEFAULT_SEPARATOR, map);
    }

    public static Map<PathString, Object> toPathStringMap(Map<String, Object> map) {
        return PathString.toPathStringMap(DEFAULT_SEPARATOR, map);
    }

    public String[] getPath() {
        return this.path;
    }

    public Object[] getPathAsObject() {
        return this.path;
    }

    public boolean isRoot() {
        return this.path.length == 0;
    }

    public String getLastPath() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public PathString append(PathString pathString) {
        String[] newPath = new String[this.path.length + pathString.path.length];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        System.arraycopy(pathString.path, 0, newPath, this.path.length, pathString.path.length);
        return new PathString(newPath);
    }

    public PathString append(String ... path) {
        return this.append(new PathString(path));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathString that = (PathString)o;
        return Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        return Arrays.hashCode(this.path);
    }

    @Override
    public int compareTo(@NotNull PathString o) {
        int length = Math.min(this.path.length, o.path.length);
        for (int i = 0; i < length; ++i) {
            int compare = this.path[i].compareTo(o.path[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(this.path.length, o.path.length);
    }
}

