/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.logger.common.LogLevel;

public class GsonConfig
implements Config {
    private final Gson gson;
    private final File file;
    private JsonObject root = new JsonObject();

    public GsonConfig(File file, Gson gson) {
        this.file = file;
        this.gson = gson;
    }

    public GsonConfig(File file) {
        this(file, new Gson());
    }

    private static Map<PathString, Object> getValues(JsonObject object, boolean deep) {
        HashMap<PathString, Object> values = new HashMap<PathString, Object>();
        for (Map.Entry entry : object.entrySet()) {
            PathString key = new PathString(new String[]{(String)entry.getKey()});
            JsonElement element = (JsonElement)entry.getValue();
            values.put(key, element);
            if (!element.isJsonObject() || !deep) continue;
            Map<PathString, Object> subValues = GsonConfig.getValues(element.getAsJsonObject(), true);
            for (Map.Entry<PathString, Object> subEntry : subValues.entrySet()) {
                values.put(key.append(subEntry.getKey()), subEntry.getValue());
            }
        }
        return values;
    }

    public JsonObject getOriginal() {
        return this.root;
    }

    private Optional<JsonObject> getJsonObject(PathString path, boolean createIfNotFound) {
        JsonObject currentObject = this.root;
        if (path.isRoot()) {
            return Optional.of(currentObject);
        }
        String[] pathArray = path.getPath();
        for (int i = 0; i < pathArray.length; ++i) {
            JsonNull element;
            String key = pathArray[i];
            if (i == pathArray.length - 1) {
                return Optional.of(currentObject);
            }
            Object object = element = currentObject.has(key) ? currentObject.get(key) : JsonNull.INSTANCE;
            if (element.isJsonObject()) {
                currentObject = element.getAsJsonObject();
                continue;
            }
            if (createIfNotFound) {
                JsonObject newObject = new JsonObject();
                currentObject.add(key, (JsonElement)newObject);
                currentObject = newObject;
                continue;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Object get(PathString path, Object def) {
        if (path.isRoot()) {
            return this.root;
        }
        return this.getJsonObject(path, false).map(object -> {
            String lastPath = path.getLastPath();
            if (object.has(lastPath)) {
                return object.get(lastPath);
            }
            return null;
        }).orElseGet(() -> {
            if (def == null) {
                return null;
            }
            if (def instanceof JsonElement) {
                return def;
            }
            return this.gson.toJsonTree(def);
        });
    }

    public void set(PathString path, Object value) {
        JsonElement element;
        JsonElement jsonElement = element = value instanceof JsonElement ? (JsonElement)value : this.gson.toJsonTree(value);
        if (path.isRoot()) {
            if (element.isJsonObject()) {
                this.root = element.getAsJsonObject();
            }
            return;
        }
        this.getJsonObject(path, true).ifPresent(object -> {
            if (element.isJsonNull()) {
                object.remove(path.getLastPath());
            } else {
                object.add(path.getLastPath(), element);
            }
        });
    }

    public void clear() {
        this.root = new JsonObject();
    }

    public String getName() {
        return this.file.getName();
    }

    public Map<PathString, Object> getValues(PathString path, boolean deep) {
        if (path.isRoot()) {
            return GsonConfig.getValues(this.root, deep);
        }
        return this.getJsonObject(path, false).map(object -> GsonConfig.getValues(object, deep)).orElse(Collections.emptyMap());
    }

    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when creating " + this.file.getName(), (Throwable)e);
            }
        }
        try (FileReader reader = new FileReader(this.file);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement.isJsonObject()) {
                this.root = jsonElement.getAsJsonObject();
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when loading " + this.file.getName(), (Throwable)e);
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            jsonWriter.setIndent("  ");
            this.gson.toJson((JsonElement)this.root, jsonWriter);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when saving " + this.file.getName(), (Throwable)e);
        }
    }

    public void reload() {
        this.root = new JsonObject();
        this.setup();
    }

    public Object normalize(Object object) {
        if (!this.isNormalizable(object)) {
            return object;
        }
        JsonElement jsonElement = (JsonElement)object;
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean();
            }
            if (jsonPrimitive.isNumber()) {
                return jsonPrimitive.getAsNumber();
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
        } else {
            if (jsonElement.isJsonArray()) {
                return jsonElement.getAsJsonArray().asList();
            }
            if (jsonElement.isJsonObject()) {
                return jsonElement.getAsJsonObject().asMap();
            }
            if (jsonElement.isJsonNull()) {
                return null;
            }
        }
        return jsonElement.getAsString();
    }

    public boolean isNormalizable(Object object) {
        return object instanceof JsonElement;
    }
}

