/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.proxy;

import java.util.concurrent.atomic.AtomicReference;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.annotation.converter.Converter;

public class ConfigNode {
    private final String path;
    private final Config config;
    private final Converter converter;
    private final Object defaultValue;
    private final String comment;
    private final boolean stickyValue;
    private final AtomicReference<Object> cachedValue = new AtomicReference();

    ConfigNode(String path, Config config, Converter converter, Object defaultValue, String comment, boolean stickyValue) {
        this.path = path;
        this.config = config;
        this.converter = converter;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.stickyValue = stickyValue;
    }

    public String getPath() {
        return this.path;
    }

    public void addDefault() {
        this.config.addDefault(this.path, this.converter.convertToRaw(this.defaultValue));
        if (this.comment != null && this.config.getComment(this.path) == null) {
            this.config.setComment(this.path, this.comment);
        }
    }

    public Object getValue() {
        Object cached = this.cachedValue.get();
        if (cached != null && this.stickyValue) {
            return cached;
        }
        Object rawValue = this.config.getNormalized(this.path);
        if (rawValue == null) {
            return this.defaultValue;
        }
        Object value = this.converter.convert(rawValue);
        Object finalValue = value == null ? this.defaultValue : value;
        this.cachedValue.set(finalValue);
        return finalValue;
    }

    public void setValue(Object value) {
        this.config.set(this.path, this.converter.convertToRaw(value));
        this.cachedValue.set(null);
    }

    public void clearCache() {
        this.cachedValue.set(null);
    }
}

