/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.config.annotation.Comment;
import me.hsgamer.hscore.config.annotation.ConfigPath;
import me.hsgamer.hscore.config.annotation.StickyValue;
import me.hsgamer.hscore.config.annotation.converter.manager.DefaultConverterManager;
import me.hsgamer.hscore.config.proxy.ConfigNode;
import me.hsgamer.hscore.config.proxy.defaulthandler.DefaultMethodHandler;
import me.hsgamer.hscore.config.proxy.defaulthandler.NewJavaDefaultMethodHandler;
import me.hsgamer.hscore.config.proxy.defaulthandler.OldJavaDefaultMethodHandler;

public class ConfigInvocationHandler<T>
implements InvocationHandler {
    private static final DefaultMethodHandler DEFAULT_METHOD_HANDLER;
    private final Map<String, ConfigNode> nodes = new HashMap<String, ConfigNode>();
    private final Class<T> clazz;
    private final Config config;
    private final boolean stickyValue;

    ConfigInvocationHandler(Class<T> clazz, Config config, boolean stickyValue, boolean addDefault) {
        this.clazz = clazz;
        this.config = config;
        this.stickyValue = stickyValue;
        Arrays.stream(this.clazz.getDeclaredMethods()).sorted(Comparator.comparingInt(Method::hashCode)).forEach(this::setupMethod);
        if (addDefault) {
            this.nodes.values().forEach(ConfigNode::addDefault);
            this.setupClassComment();
            this.config.save();
        }
    }

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Double.class);
    }

    private static boolean isVoidMethod(Method method) {
        return method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class;
    }

    private void setupClassComment() {
        if (this.clazz.isAnnotationPresent(Comment.class) && this.config.getComment(PathString.ROOT) == null) {
            this.config.setComment(PathString.ROOT, Arrays.asList(this.clazz.getAnnotation(Comment.class).value()));
        }
    }

    private void setupMethod(Method method) {
        if (!method.isDefault() || method.getParameterCount() != 0) {
            return;
        }
        String name = method.getName();
        String methodName = name.startsWith("get") ? name.substring(3) : (name.startsWith("is") ? name.substring(2) : name);
        if (methodName.isEmpty()) {
            return;
        }
        if (!method.isAnnotationPresent(ConfigPath.class)) {
            return;
        }
        ConfigPath configPath = method.getAnnotation(ConfigPath.class);
        String[] path = configPath.value();
        try {
            Object value = DEFAULT_METHOD_HANDLER.invoke(method, new Object[0]);
            ConfigNode node = new ConfigNode(path, this.config, DefaultConverterManager.getConverterIfDefault((Type)method.getGenericReturnType(), (Class)configPath.converter()), value, method.isAnnotationPresent(Comment.class) ? Arrays.asList(method.getAnnotation(Comment.class).value()) : Collections.emptyList(), this.stickyValue || method.isAnnotationPresent(StickyValue.class));
            this.nodes.put(methodName, node);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to setup method " + method.getName(), e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        String name = method.getName();
        if ((name.equals("getConfig") || name.equals("config")) && !method.isDefault() && method.getParameterCount() == 0 && method.getReturnType().isInstance(this.config)) {
            return this.config;
        }
        if (name.equals("toString")) {
            return this.clazz.toString();
        }
        if (name.equals("hashCode")) {
            return this.clazz.hashCode();
        }
        if (name.equals("equals")) {
            return proxy == args[0];
        }
        if ((name.equals("reloadConfig") || name.equals("reload")) && !method.isDefault() && method.getParameterCount() == 0) {
            this.config.reload();
            this.nodes.values().forEach(ConfigNode::clearCache);
            return null;
        }
        if (!ConfigInvocationHandler.isVoidMethod(method) && method.isDefault() && method.getParameterCount() == 0 && method.isAnnotationPresent(ConfigPath.class)) {
            String methodName2 = name.startsWith("get") ? name.substring(3) : (name.startsWith("is") ? name.substring(2) : name);
            if (this.nodes.containsKey(methodName2)) {
                Object value = this.nodes.get(methodName2).getValue();
                if (ConfigInvocationHandler.isPrimitiveOrWrapper(method.getReturnType()) && ConfigInvocationHandler.isPrimitiveOrWrapper(value.getClass()) || method.getReturnType().isInstance(value)) {
                    return value;
                }
            }
        } else if (ConfigInvocationHandler.isVoidMethod(method) && !method.isDefault() && method.getParameterCount() == 1 && this.nodes.containsKey(methodName = name.startsWith("set") ? name.substring(3) : name)) {
            this.nodes.get(methodName).setValue(args[0]);
            this.config.save();
            return null;
        }
        if (method.isDefault()) {
            return DEFAULT_METHOD_HANDLER.invoke(proxy, method, args);
        }
        throw new UnsupportedOperationException("Method " + method.getName() + " is not supported");
    }

    static {
        float version = Float.parseFloat(System.getProperty("java.class.version"));
        DEFAULT_METHOD_HANDLER = version <= 52.0f ? new OldJavaDefaultMethodHandler() : new NewJavaDefaultMethodHandler();
    }
}

