/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.simpleconfiguration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.Config;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.comments.Commentable;
import org.simpleyaml.configuration.file.FileConfiguration;

public class SimpleConfig<T extends FileConfiguration>
implements Config {
    protected final BiConsumer<File, T> loader;
    private final File file;
    private final T configuration;

    public SimpleConfig(File file, T configuration, BiConsumer<File, T> loader) {
        this.file = file;
        this.configuration = configuration;
        this.loader = loader;
    }

    public SimpleConfig(File file, T configuration) {
        this(file, (FileConfiguration)configuration, (file1, t) -> {
            try {
                t.load(file1);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Something wrong when loading " + file1.getName());
            }
        });
    }

    public FileConfiguration getOriginal() {
        return this.configuration;
    }

    public Object get(String path, Object def) {
        return this.configuration.get(path, def);
    }

    public void set(String path, Object value) {
        this.configuration.set(path, value);
    }

    public boolean contains(String path) {
        return this.configuration.isSet(path);
    }

    public String getName() {
        return this.file.getName();
    }

    public void addDefault(String path, Object value) {
        this.configuration.addDefault(path, value);
    }

    public Map<String, Object> getValues(String path, boolean deep) {
        if (path == null || path.isEmpty()) {
            return this.configuration.getValues(deep);
        }
        return Optional.ofNullable(this.configuration.getConfigurationSection(path)).map(configurationSection -> configurationSection.getValues(deep)).orElse(Collections.emptyMap());
    }

    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Something wrong when creating " + this.file.getName());
            }
        }
        this.configuration.options().copyDefaults(true);
        this.loader.accept(this.file, (File)this.configuration);
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Something wrong when saving " + this.file.getName());
        }
    }

    public void reload() {
        ArrayList keys = new ArrayList(this.configuration.getKeys(false));
        keys.forEach(key -> this.configuration.set(key, null));
        this.setup();
    }

    public Object normalize(Object object) {
        if (object instanceof ConfigurationSection) {
            return ((ConfigurationSection)object).getValues(false);
        }
        return object;
    }

    public boolean isNormalizable(Object object) {
        return object instanceof ConfigurationSection;
    }

    public String getComment(String path, CommentType type) {
        if (this.configuration instanceof Commentable) {
            try {
                org.simpleyaml.configuration.comments.CommentType commentType = org.simpleyaml.configuration.comments.CommentType.valueOf((String)type.name());
                return ((Commentable)this.configuration).getComment(path, commentType);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> "Something wrong when getting comment of " + path);
            }
        }
        return "";
    }

    public void setComment(String path, String value, CommentType type) {
        if (this.configuration instanceof Commentable) {
            try {
                org.simpleyaml.configuration.comments.CommentType commentType = org.simpleyaml.configuration.comments.CommentType.valueOf((String)type.name());
                ((Commentable)this.configuration).setComment(path, value, commentType);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> "Something wrong when setting comment of " + path);
            }
        }
    }
}

