/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.simpleconfiguration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.logger.common.LogLevel;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.comments.Commentable;
import org.simpleyaml.configuration.file.FileConfiguration;

public class SimpleConfig<T extends FileConfiguration>
implements Config {
    protected final BiConsumer<File, T> loader;
    private final File file;
    private final T configuration;

    public SimpleConfig(File file, T configuration, BiConsumer<File, T> loader) {
        this.file = file;
        this.configuration = configuration;
        this.loader = loader;
    }

    public SimpleConfig(File file, T configuration) {
        this(file, (FileConfiguration)configuration, (file1, t) -> {
            try {
                t.load(file1);
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when loading " + file1.getName(), (Throwable)e);
            }
        });
    }

    private String toPath(PathString pathString) {
        return PathString.toPath((String)String.valueOf(this.configuration.options().pathSeparator()), (PathString)pathString);
    }

    private Map<PathString, Object> toPathStringMap(Map<String, Object> map) {
        return PathString.toPathStringMap((String)String.valueOf(this.configuration.options().pathSeparator()), map);
    }

    public FileConfiguration getOriginal() {
        return this.configuration;
    }

    public Object get(PathString path, Object def) {
        return this.configuration.get(this.toPath(path), def);
    }

    public void set(PathString path, Object value) {
        this.configuration.set(this.toPath(path), value);
    }

    public boolean contains(PathString path) {
        return this.configuration.isSet(this.toPath(path));
    }

    public String getName() {
        return this.file.getName();
    }

    public Map<PathString, Object> getValues(PathString path, boolean deep) {
        if (path.getPath().length == 0) {
            return this.toPathStringMap(this.configuration.getValues(deep));
        }
        return Optional.ofNullable(this.configuration.getConfigurationSection(this.toPath(path))).map(configurationSection -> configurationSection.getValues(deep)).map(this::toPathStringMap).orElse(Collections.emptyMap());
    }

    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when creating " + this.file.getName(), (Throwable)e);
            }
        }
        this.loader.accept(this.file, (File)this.configuration);
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when saving " + this.file.getName(), (Throwable)e);
        }
    }

    public void reload() {
        ArrayList keys = new ArrayList(this.configuration.getKeys(false));
        keys.forEach(key -> this.configuration.set(key, null));
        this.setup();
    }

    public Object normalize(Object object) {
        if (object instanceof ConfigurationSection) {
            return ((ConfigurationSection)object).getValues(false);
        }
        return object;
    }

    public boolean isNormalizable(Object object) {
        return object instanceof ConfigurationSection;
    }

    public List<String> getComment(PathString path, CommentType type) {
        String comment = null;
        if (path.isRoot()) {
            comment = this.configuration.options().header();
        } else if (this.configuration instanceof Commentable) {
            try {
                org.simpleyaml.configuration.comments.CommentType commentType = org.simpleyaml.configuration.comments.CommentType.valueOf((String)type.name());
                comment = ((Commentable)this.configuration).getComment(this.toPath(path), commentType);
            }
            catch (Exception e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when getting comment of " + path, (Throwable)e);
            }
        }
        return comment == null ? Collections.emptyList() : Arrays.asList(comment.split("\\r?\\n"));
    }

    public void setComment(PathString path, List<String> value, CommentType type) {
        String comment;
        String string = comment = value == null || value.isEmpty() ? null : String.join((CharSequence)"\n", value);
        if (path.isRoot()) {
            this.configuration.options().header(comment).copyHeader(true);
        } else if (this.configuration instanceof Commentable) {
            try {
                org.simpleyaml.configuration.comments.CommentType commentType = org.simpleyaml.configuration.comments.CommentType.valueOf((String)type.name());
                ((Commentable)this.configuration).setComment(this.toPath(path), comment, commentType);
            }
            catch (Exception e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when setting comment of " + path, (Throwable)e);
            }
        }
    }
}

