/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.crontime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class CronTimeManager {
    protected static final Logger LOGGER = Logger.getLogger(CronTimeManager.class.getSimpleName());
    private final List<Cron> cronList;

    public CronTimeManager(@NotNull List<Cron> cronList) {
        this.cronList = cronList;
    }

    public CronTimeManager(Cron ... crons) {
        this.cronList = Arrays.asList(crons);
    }

    public CronTimeManager(@NotNull CronDefinition definition, @NotNull List<String> cronStrings) {
        this.cronList = new ArrayList<Cron>();
        CronParser parser = new CronParser(definition);
        cronStrings.forEach(cronTime -> {
            try {
                Cron cron = parser.parse(cronTime);
                this.cronList.add(cron);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex, () -> String.format("Cron time is invalid: `%s`", cronTime));
            }
        });
    }

    public CronTimeManager(@NotNull CronDefinition definition, String ... cronStrings) {
        this(definition, Arrays.asList(cronStrings));
    }

    public CronTimeManager(@NotNull CronType cronType, @NotNull List<String> cronStrings) {
        this(CronDefinitionBuilder.instanceDefinitionFor((CronType)cronType), cronStrings);
    }

    public CronTimeManager(@NotNull CronType cronType, String ... cronStrings) {
        this(cronType, Arrays.asList(cronStrings));
    }

    @NotNull
    public ZonedDateTime getNextTime() {
        return this.getNextTime(ZonedDateTime.now());
    }

    @NotNull
    public ZonedDateTime getNextTime(@NotNull ZonedDateTime initTime) {
        long currentMillis = initTime.toInstant().toEpochMilli();
        long minDelayMillis = -1L;
        ZonedDateTime nextDateTime = initTime;
        for (Cron cron : this.cronList) {
            ZonedDateTime time;
            long delayMillis;
            Optional optionalTime = ExecutionTime.forCron((Cron)cron).nextExecution(initTime);
            if (!optionalTime.isPresent() || (delayMillis = (time = (ZonedDateTime)optionalTime.get()).toInstant().toEpochMilli() - currentMillis) >= minDelayMillis && minDelayMillis != -1L) continue;
            minDelayMillis = delayMillis;
            nextDateTime = time;
        }
        return nextDateTime;
    }

    public long getNextEpochMillis() {
        return this.getNextTime().toInstant().toEpochMilli();
    }

    public long getNextEpochMillis(@NotNull ZonedDateTime initTime) {
        return this.getNextTime(initTime).toInstant().toEpochMilli();
    }

    public long getRemainingMillis() {
        return this.getNextEpochMillis() - System.currentTimeMillis();
    }

    public long getRemainingMillis(@NotNull ZonedDateTime initTime) {
        return this.getNextEpochMillis(initTime) - System.currentTimeMillis();
    }

    @NotNull
    public List<Cron> getCronList() {
        return Collections.unmodifiableList(this.cronList);
    }
}

