/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.crontime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class CronTimeManager {
    protected static final Logger LOGGER = LoggerProvider.getLogger(CronTimeManager.class);
    private final List<Cron> cronList;

    public CronTimeManager(@NotNull List<Cron> cronList) {
        this.cronList = cronList;
    }

    public CronTimeManager(Cron ... crons) {
        this.cronList = Arrays.asList(crons);
    }

    public CronTimeManager(@NotNull CronDefinition definition, @NotNull List<String> cronStrings) {
        this.cronList = new ArrayList<Cron>();
        CronParser parser = new CronParser(definition);
        cronStrings.forEach(cronTime -> {
            try {
                Cron cron = parser.parse(cronTime);
                this.cronList.add(cron);
            }
            catch (Exception ex) {
                LOGGER.log(LogLevel.WARN, "Cron time is invalid: `" + cronTime + "`", (Throwable)ex);
            }
        });
    }

    public CronTimeManager(@NotNull CronDefinition definition, String ... cronStrings) {
        this(definition, Arrays.asList(cronStrings));
    }

    public CronTimeManager(@NotNull CronType cronType, @NotNull List<String> cronStrings) {
        this(CronDefinitionBuilder.instanceDefinitionFor((CronType)cronType), cronStrings);
    }

    public CronTimeManager(@NotNull CronType cronType, String ... cronStrings) {
        this(cronType, Arrays.asList(cronStrings));
    }

    @NotNull
    public ZonedDateTime getNextTime(@NotNull ZonedDateTime initTime) {
        long currentMillis = initTime.toInstant().toEpochMilli();
        long minDelayMillis = -1L;
        ZonedDateTime nextDateTime = initTime;
        for (Cron cron : this.cronList) {
            ZonedDateTime time;
            long delayMillis;
            Optional optionalTime = ExecutionTime.forCron((Cron)cron).nextExecution(initTime);
            if (!optionalTime.isPresent() || (delayMillis = (time = (ZonedDateTime)optionalTime.get()).toInstant().toEpochMilli() - currentMillis) >= minDelayMillis && minDelayMillis >= 0L) continue;
            minDelayMillis = delayMillis;
            nextDateTime = time;
        }
        return nextDateTime;
    }

    @NotNull
    public ZonedDateTime getNextTime() {
        return this.getNextTime(ZonedDateTime.now());
    }

    @NotNull
    public Instant getNextInstant(@NotNull Instant initInstant) {
        ZonedDateTime initTime = ZonedDateTime.ofInstant(initInstant, TimeZone.getDefault().toZoneId());
        ZonedDateTime nextTime = this.getNextTime(initTime);
        return nextTime.toInstant();
    }

    @NotNull
    public Instant getNextInstant() {
        return this.getNextInstant(Instant.now());
    }

    public long getNextEpochMillis(@NotNull ZonedDateTime initTime) {
        return this.getNextTime(initTime).toInstant().toEpochMilli();
    }

    public long getNextEpochMillis() {
        return this.getNextEpochMillis(ZonedDateTime.now());
    }

    public long getNextEpochMillis(@NotNull Instant initInstant) {
        return this.getNextEpochMillis(ZonedDateTime.ofInstant(initInstant, TimeZone.getDefault().toZoneId()));
    }

    public long getRemainingMillis(@NotNull ZonedDateTime initTime) {
        return this.getNextEpochMillis(initTime) - initTime.toInstant().toEpochMilli();
    }

    public long getRemainingMillis() {
        return this.getRemainingMillis(ZonedDateTime.now());
    }

    public long getRemainingMillis(@NotNull Instant initInstant) {
        return this.getRemainingMillis(ZonedDateTime.ofInstant(initInstant, TimeZone.getDefault().toZoneId()));
    }

    @NotNull
    public List<Cron> getCronList() {
        return Collections.unmodifiableList(this.cronList);
    }
}

