/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.crontime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CronTimeParser {
    public static List<Cron> parse(@NotNull CronDefinition definition, @NotNull List<String> cronStrings) {
        ArrayList<Cron> cronList = new ArrayList<Cron>();
        CronParser parser = new CronParser(definition);
        cronStrings.forEach(cronTime -> {
            try {
                Cron cron = parser.parse(cronTime);
                cronList.add(cron);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return cronList;
    }

    public static List<Cron> parse(@NotNull CronDefinition definition, String ... cronStrings) {
        return CronTimeParser.parse(definition, Arrays.asList(cronStrings));
    }

    public static List<Cron> parse(@NotNull CronType type, @NotNull List<String> cronStrings) {
        return CronTimeParser.parse(CronDefinitionBuilder.instanceDefinitionFor((CronType)type), cronStrings);
    }

    public static List<Cron> parse(@NotNull CronType type, String ... cronStrings) {
        return CronTimeParser.parse(type, Arrays.asList(cronStrings));
    }
}

