/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.database.client.sql.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import me.hsgamer.hscore.database.Driver;
import me.hsgamer.hscore.database.LocalDriver;
import me.hsgamer.hscore.database.Setting;
import me.hsgamer.hscore.database.client.sql.BaseSqlClient;

public class HikariSqlClient
extends BaseSqlClient<HikariDataSource> {
    private final HikariDataSource hikariDataSource;

    public HikariSqlClient(Setting setting) {
        super(setting);
        Driver driver = setting.getDriver();
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(driver.getDriverClassName());
        config.setJdbcUrl(driver.convertURL(setting));
        if (driver instanceof LocalDriver) {
            config.setPoolName("LOCALDB-" + setting.getDatabaseName());
            config.setMaxLifetime(60000L);
            config.setIdleTimeout(45000L);
            config.setMaximumPoolSize(50);
        } else {
            config.setUsername(setting.getUsername());
            config.setPassword(setting.getPassword());
            config.addDataSourceProperty("cachePrepStmts", (Object)true);
            config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
            config.addDataSourceProperty("useServerPrepStmts", (Object)true);
            config.addDataSourceProperty("useLocalSessionState", (Object)true);
            config.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
            config.addDataSourceProperty("cacheResultSetMetadata", (Object)true);
            config.addDataSourceProperty("cacheServerConfiguration", (Object)true);
            config.addDataSourceProperty("elideSetAutoCommits", (Object)true);
            config.addDataSourceProperty("maintainTimeStats", (Object)false);
        }
        setting.getClientProperties().forEach((arg_0, arg_1) -> ((HikariConfig)config).addDataSourceProperty(arg_0, arg_1));
        this.hikariDataSource = new HikariDataSource(config);
    }

    public HikariDataSource getOriginal() {
        return this.hikariDataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }
}

